/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import java.util.List;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntityManager;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.entitylink.service.EntityLinkServiceConfiguration;

public abstract class AbstractProcessInstanceDeleteHistoryTransformer
extends AbstractHistoryJsonTransformer {
    public AbstractProcessInstanceDeleteHistoryTransformer(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    protected void deleteProcessInstance(String processInstanceId, CommandContext commandContext) {
        HistoricProcessInstanceEntityManager historicProcessInstanceEntityManager = this.processEngineConfiguration.getHistoricProcessInstanceEntityManager();
        HistoricProcessInstanceEntity historicProcessInstance = (HistoricProcessInstanceEntity)historicProcessInstanceEntityManager.findById(processInstanceId);
        this.processEngineConfiguration.getHistoricDetailEntityManager().deleteHistoricDetailsByProcessInstanceId(processInstanceId);
        this.processEngineConfiguration.getVariableServiceConfiguration().getHistoricVariableService().deleteHistoricVariableInstancesByProcessInstanceId(processInstanceId);
        this.processEngineConfiguration.getHistoricActivityInstanceEntityManager().deleteHistoricActivityInstancesByProcessInstanceId(processInstanceId);
        TaskHelper.deleteHistoricTaskInstancesByProcessInstanceId(processInstanceId);
        this.processEngineConfiguration.getIdentityLinkServiceConfiguration().getHistoricIdentityLinkService().deleteHistoricIdentityLinksByProcessInstanceId(processInstanceId);
        EntityLinkServiceConfiguration entityLinkServiceConfiguration = this.processEngineConfiguration.getEntityLinkServiceConfiguration();
        if (entityLinkServiceConfiguration != null) {
            entityLinkServiceConfiguration.getHistoricEntityLinkService().deleteHistoricEntityLinksByScopeIdAndScopeType(processInstanceId, "bpmn");
        }
        this.processEngineConfiguration.getCommentEntityManager().deleteCommentsByProcessInstanceId(processInstanceId);
        historicProcessInstanceEntityManager.delete(historicProcessInstance, false);
        List<HistoricProcessInstance> selectList = historicProcessInstanceEntityManager.findHistoricProcessInstancesBySuperProcessInstanceId(processInstanceId);
        for (HistoricProcessInstance child : selectList) {
            this.deleteProcessInstance(child.getId(), commandContext);
        }
    }
}

