/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.job.service.JobProcessorContext;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.asyncexecutor.TimerJobScheduler;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntityManager;
import org.flowable.job.service.impl.util.JobProcessorUtil;
import org.flowable.variable.api.delegate.VariableScope;

public class TimerJobSchedulerImpl
implements TimerJobScheduler {
    protected final JobServiceConfiguration jobServiceConfiguration;

    public TimerJobSchedulerImpl(JobServiceConfiguration jobServiceConfiguration) {
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    @Override
    public void rescheduleTimerJobAfterExecution(JobEntity timerJob, VariableScope variableScope) {
        TimerJobEntityManager timerJobEntityManager;
        TimerJobEntity newTimerJobEntity;
        if (timerJob.getRepeat() != null && (newTimerJobEntity = (timerJobEntityManager = this.jobServiceConfiguration.getTimerJobEntityManager()).createAndCalculateNextTimer(timerJob, variableScope)) != null) {
            if (this.jobServiceConfiguration.getInternalJobManager() != null) {
                this.jobServiceConfiguration.getInternalJobManager().preRepeatedTimerSchedule(newTimerJobEntity, variableScope);
            }
            this.scheduleTimerJob(newTimerJobEntity);
        }
    }

    @Override
    public void scheduleTimerJob(TimerJobEntity timerJob) {
        this.scheduleTimer(timerJob);
        this.sendTimerScheduledEvent(timerJob);
    }

    protected void scheduleTimer(TimerJobEntity timerJob) {
        if (timerJob == null) {
            throw new FlowableException("Empty timer job can not be scheduled");
        }
        JobProcessorUtil.callJobProcessors(this.jobServiceConfiguration, JobProcessorContext.Phase.BEFORE_CREATE, timerJob);
        this.jobServiceConfiguration.getTimerJobEntityManager().insert(timerJob);
    }

    protected void sendTimerScheduledEvent(TimerJobEntity timerJob) {
        FlowableEventDispatcher eventDispatcher = this.jobServiceConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.TIMER_SCHEDULED, timerJob), this.jobServiceConfiguration.getEngineName());
        }
    }
}

