/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.EntityManagerFactoryImpl;
import org.apache.openjpa.persistence.EntityManagerFactoryValue;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.util.ApplicationIds;
import org.apache.openjpa.util.BigDecimalId;
import org.apache.openjpa.util.BigIntegerId;
import org.apache.openjpa.util.ByteId;
import org.apache.openjpa.util.CharId;
import org.apache.openjpa.util.DoubleId;
import org.apache.openjpa.util.FloatId;
import org.apache.openjpa.util.Id;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.IntId;
import org.apache.openjpa.util.LongId;
import org.apache.openjpa.util.ObjectId;
import org.apache.openjpa.util.OpenJPAId;
import org.apache.openjpa.util.ShortId;
import org.apache.openjpa.util.StringId;
import org.apache.openjpa.util.UserException;

public class JPAFacadeHelper {
    public static final String EM_KEY = "org.apache.openjpa.persistence.EntityManager";
    public static final String EMF_KEY = "org.apache.openjpa.persistence.EntityManagerFactory";
    private static final Localizer _loc = Localizer.forPackage(JPAFacadeHelper.class);

    public static OpenJPAEntityManagerFactory toEntityManagerFactory(BrokerFactory factory) {
        if (factory == null) {
            return null;
        }
        factory.lock();
        try {
            OpenJPAEntityManagerFactory emf = (OpenJPAEntityManagerFactory)factory.getUserObject((Object)EMF_KEY);
            if (emf == null) {
                emf = EntityManagerFactoryValue.newFactory(factory);
                factory.putUserObject((Object)EMF_KEY, (Object)emf);
            }
            OpenJPAEntityManagerFactory openJPAEntityManagerFactory = emf;
            return openJPAEntityManagerFactory;
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
        finally {
            factory.unlock();
        }
    }

    public static BrokerFactory toBrokerFactory(EntityManagerFactory emf) {
        if (emf == null) {
            return null;
        }
        if (!(emf instanceof EntityManagerFactoryImpl)) {
            Class<?> c = emf.getClass();
            try {
                emf = (EntityManagerFactoryImpl)((OpenJPAEntityManagerFactory)emf).getUserObject(EMF_KEY);
            }
            catch (ClassCastException cce) {
                throw new ArgumentException(_loc.get("cant-convert-brokerfactory", c), null, null, false);
            }
        }
        return ((EntityManagerFactoryImpl)emf).getBrokerFactory();
    }

    public static OpenJPAEntityManager toEntityManager(Broker broker) {
        if (broker == null) {
            return null;
        }
        broker.lock();
        try {
            OpenJPAEntityManager em = (OpenJPAEntityManager)broker.getUserObject((Object)EM_KEY);
            if (em == null) {
                EntityManagerFactoryImpl emf = (EntityManagerFactoryImpl)JPAFacadeHelper.toEntityManagerFactory(broker.getBrokerFactory());
                em = emf.newEntityManagerImpl(broker);
                broker.putUserObject((Object)EM_KEY, (Object)em);
            }
            OpenJPAEntityManager openJPAEntityManager = em;
            return openJPAEntityManager;
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
        finally {
            broker.unlock();
        }
    }

    public static Broker toBroker(EntityManager em) {
        if (em == null) {
            return null;
        }
        if (!(em instanceof EntityManagerImpl)) {
            Class<?> c = em.getClass();
            try {
                em = (EntityManagerImpl)((OpenJPAEntityManager)em).getUserObject(EM_KEY);
            }
            catch (ClassCastException cce) {
                throw new ArgumentException(_loc.get("cant-convert-broker", c), new Throwable[]{cce}, null, false);
            }
        }
        return ((EntityManagerImpl)em).getBroker();
    }

    public static ClassMetaData getMetaData(Object o) {
        if (o == null) {
            return null;
        }
        OpenJPAEntityManager em = OpenJPAPersistence.getEntityManager(o);
        return em == null ? null : JPAFacadeHelper.getMetaData(em, ImplHelper.getManagedInstance((Object)o).getClass());
    }

    public static ClassMetaData getMetaData(EntityManager em, Class cls) {
        if (em == null) {
            throw new NullPointerException("em == null");
        }
        OpenJPAEntityManagerSPI kem = (OpenJPAEntityManagerSPI)OpenJPAPersistence.cast(em);
        try {
            return kem.getConfiguration().getMetaDataRepositoryInstance().getMetaData(cls, kem.getClassLoader(), false);
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    public static ClassMetaData getMetaData(EntityManagerFactory emf, Class cls) {
        if (emf == null) {
            throw new NullPointerException("emf == null");
        }
        OpenJPAEntityManagerFactorySPI emfSPI = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast(emf);
        try {
            return emfSPI.getConfiguration().getMetaDataRepositoryInstance().getMetaData(cls, null, false);
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    public static Object fromOpenJPAObjectId(Object oid) {
        if (oid instanceof OpenJPAId) {
            return ((OpenJPAId)oid).getIdObject();
        }
        return oid;
    }

    public static Object toOpenJPAObjectId(ClassMetaData meta, Object oid) {
        if (oid == null || meta == null) {
            return null;
        }
        if (oid instanceof OpenJPAId) {
            return oid;
        }
        Class cls = meta.getDescribedType();
        FieldMetaData[] pks = meta.getPrimaryKeyFields();
        Class expected = meta.getObjectIdType();
        try {
            switch (meta.getIdentityType()) {
                case 1: {
                    if (oid instanceof String && ((String)oid).startsWith("openjpasm:")) {
                        return new BrokerImpl.StateManagerId((String)oid);
                    }
                    return new Id(cls, ((Number)oid).longValue());
                }
                case 2: {
                    Object[] objectArray;
                    if (ImplHelper.isAssignable((Class)meta.getObjectIdType(), oid.getClass())) {
                        if (!meta.isOpenJPAIdentity() && meta.isObjectIdTypeShared()) {
                            return new ObjectId(cls, oid);
                        }
                        return oid;
                    }
                    expected = meta.getIdClass() == null ? pks[0].getDeclaredType() : meta.getIdClass();
                    if (oid instanceof String && !meta.getRepository().getConfiguration().getCompatibilityInstance().getStrictIdentityValues() && !Modifier.isAbstract(cls.getModifiers())) {
                        return PCRegistry.newObjectId((Class)cls, (String)((String)oid));
                    }
                    if (oid instanceof Object[]) {
                        objectArray = (Object[])oid;
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = oid;
                    }
                    Object[] arr = objectArray;
                    Object rtrn = ApplicationIds.fromPKValues((Object[])arr, (ClassMetaData)meta);
                    if (rtrn == null || meta.getObjectIdType() == null) break;
                    if (rtrn instanceof ObjectId) {
                        if (pks.length <= 0 || !pks[0].isEmbedded() && !pks[0].isTypePC()) break;
                        Class idClass = meta.getIdClass();
                        if (!pks[0].getDeclaredType().equals(oid.getClass()) && (idClass == null || !idClass.equals(oid.getClass()))) break;
                        return rtrn;
                    }
                    if (rtrn instanceof StringId && (!(rtrn instanceof StringId) || !(oid instanceof String))) break;
                    return rtrn;
                }
            }
            throw new UserException(_loc.get("invalid-oid", new Object[]{expected, oid.getClass()}));
        }
        catch (RuntimeException re) {
            if (expected == null) {
                throw new UserException(_loc.get("invalid-oid", new Object[]{Number.class, oid.getClass()}));
            }
            throw new UserException(_loc.get("invalid-oid", new Object[]{expected, oid.getClass()}));
        }
    }

    public static Object[] toOpenJPAObjectIds(ClassMetaData meta, Object ... oids) {
        if (oids == null || oids.length == 0) {
            return oids;
        }
        Object oid = JPAFacadeHelper.toOpenJPAObjectId(meta, oids[0]);
        if (oid == oids[0]) {
            return oids;
        }
        Object[] copy = new Object[oids.length];
        copy[0] = oid;
        for (int i = 1; i < oids.length; ++i) {
            copy[i] = JPAFacadeHelper.toOpenJPAObjectId(meta, oids[i]);
        }
        return copy;
    }

    public static Collection<Object> toOpenJPAObjectIds(ClassMetaData meta, Collection<Object> oids) {
        if (oids == null || oids.size() == 0) {
            return oids;
        }
        return Arrays.asList(JPAFacadeHelper.toOpenJPAObjectIds(meta, oids.toArray()));
    }

    public static Class fromOpenJPAObjectIdClass(Class oidClass) {
        if (oidClass == null) {
            return null;
        }
        if (oidClass == Id.class) {
            return Long.class;
        }
        if (oidClass == ByteId.class) {
            return Byte.class;
        }
        if (oidClass == CharId.class) {
            return Character.class;
        }
        if (oidClass == DoubleId.class) {
            return Double.class;
        }
        if (oidClass == FloatId.class) {
            return Float.class;
        }
        if (oidClass == IntId.class) {
            return Integer.class;
        }
        if (oidClass == LongId.class) {
            return Long.class;
        }
        if (oidClass == ShortId.class) {
            return Short.class;
        }
        if (oidClass == StringId.class) {
            return String.class;
        }
        if (oidClass == BigDecimalId.class) {
            return BigDecimal.class;
        }
        if (oidClass == BigIntegerId.class) {
            return BigInteger.class;
        }
        return oidClass;
    }
}

