/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.impl.BasePasswordManagementService;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.hjson.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class JsonResourcePasswordManagementService
extends BasePasswordManagementService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonResourcePasswordManagementService.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final Resource jsonResource;
    private Map<String, JsonBackedAccount> jsonBackedAccounts;

    public JsonResourcePasswordManagementService(CipherExecutor<Serializable, String> cipherExecutor, String issuer, PasswordManagementProperties passwordManagementProperties, Resource jsonResource, PasswordHistoryService passwordHistoryService) {
        super(passwordManagementProperties, cipherExecutor, issuer, passwordHistoryService);
        this.jsonResource = jsonResource;
        this.readAccountsFromJsonResource();
    }

    @Override
    public boolean changeInternal(@NonNull Credential credential, @NonNull PasswordChangeRequest bean) {
        if (credential == null) {
            throw new NullPointerException("credential is marked non-null but is null");
        }
        if (bean == null) {
            throw new NullPointerException("bean is marked non-null but is null");
        }
        UsernamePasswordCredential c = (UsernamePasswordCredential)credential;
        if (StringUtils.isBlank((CharSequence)bean.getPassword())) {
            LOGGER.error("Password cannot be blank");
            return false;
        }
        if (!StringUtils.equals((CharSequence)bean.getPassword(), (CharSequence)bean.getConfirmedPassword())) {
            LOGGER.error("Password does not match and cannot be confirmed");
            return false;
        }
        JsonBackedAccount account = this.jsonBackedAccounts.getOrDefault(c.getId(), null);
        if (account == null) {
            LOGGER.error("User account [{}] cannot be found", (Object)c.getId());
            return false;
        }
        account.setPassword(bean.getPassword());
        this.jsonBackedAccounts.put(c.getId(), account);
        return this.writeAccountToJsonResource();
    }

    @Override
    public String findEmail(PasswordManagementQuery query) {
        JsonBackedAccount account = this.jsonBackedAccounts.getOrDefault(query.getUsername(), null);
        return Optional.ofNullable(account).map(JsonBackedAccount::getEmail).orElse(null);
    }

    @Override
    public String findPhone(PasswordManagementQuery query) {
        JsonBackedAccount account = this.jsonBackedAccounts.getOrDefault(query.getUsername(), null);
        return Optional.ofNullable(account).map(JsonBackedAccount::getPhone).orElse(null);
    }

    @Override
    public String findUsername(PasswordManagementQuery query) {
        Optional<Map.Entry> result = this.jsonBackedAccounts.entrySet().stream().filter(entry -> ((JsonBackedAccount)entry.getValue()).getEmail().equalsIgnoreCase(query.getEmail())).findFirst();
        return result.map(Map.Entry::getKey).orElse(null);
    }

    @Override
    public Map<String, String> getSecurityQuestions(PasswordManagementQuery query) {
        JsonBackedAccount account = this.jsonBackedAccounts.getOrDefault(query.getUsername(), null);
        if (account != null) {
            return account.getSecurityQuestions();
        }
        return new HashMap<String, String>(0);
    }

    @Override
    public void updateSecurityQuestions(PasswordManagementQuery query) {
        JsonBackedAccount account = this.jsonBackedAccounts.getOrDefault(query.getUsername(), null);
        if (account != null) {
            account.setSecurityQuestions(query.getSecurityQuestions().toSingleValueMap());
            this.writeAccountToJsonResource();
        }
    }

    @Override
    public boolean unlockAccount(Credential credential) {
        JsonBackedAccount account = this.jsonBackedAccounts.getOrDefault(credential.getId(), null);
        if (account != null && "locked".equalsIgnoreCase(account.getStatus())) {
            account.setStatus("OK");
            this.writeAccountToJsonResource();
        }
        return true;
    }

    private boolean writeAccountToJsonResource() {
        return (Boolean)FunctionUtils.doUnchecked(() -> {
            MAPPER.writerWithDefaultPrettyPrinter().writeValue(this.jsonResource.getFile(), this.jsonBackedAccounts);
            this.readAccountsFromJsonResource();
            return true;
        });
    }

    private void readAccountsFromJsonResource() {
        FunctionUtils.doUnchecked(u -> {
            try (InputStreamReader reader = new InputStreamReader(this.jsonResource.getInputStream(), StandardCharsets.UTF_8);){
                TypeReference<Map<String, JsonBackedAccount>> personList = new TypeReference<Map<String, JsonBackedAccount>>(){};
                this.jsonBackedAccounts = (Map)MAPPER.readValue(JsonValue.readHjson((Reader)reader).toString(), (TypeReference)personList);
            }
        }, (Object[])new Object[0]);
    }

    private static class JsonBackedAccount
    implements Serializable {
        private static final long serialVersionUID = -8522936598053838986L;
        private String email;
        private String password;
        private String phone;
        private String status;
        private Map<String, String> securityQuestions = new HashMap<String, String>(0);

        @Generated
        public JsonBackedAccount() {
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public Map<String, String> getSecurityQuestions() {
            return this.securityQuestions;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setPassword(String password) {
            this.password = password;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setSecurityQuestions(Map<String, String> securityQuestions) {
            this.securityQuestions = securityQuestions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JsonBackedAccount)) {
                return false;
            }
            JsonBackedAccount other = (JsonBackedAccount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$email = this.email;
            String other$email = other.email;
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$password = this.password;
            String other$password = other.password;
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$phone = this.phone;
            String other$phone = other.phone;
            if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
                return false;
            }
            String this$status = this.status;
            String other$status = other.status;
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            Map<String, String> this$securityQuestions = this.securityQuestions;
            Map<String, String> other$securityQuestions = other.securityQuestions;
            return !(this$securityQuestions == null ? other$securityQuestions != null : !((Object)this$securityQuestions).equals(other$securityQuestions));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JsonBackedAccount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $email = this.email;
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $password = this.password;
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $phone = this.phone;
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            String $status = this.status;
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            Map<String, String> $securityQuestions = this.securityQuestions;
            result = result * 59 + ($securityQuestions == null ? 43 : ((Object)$securityQuestions).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JsonResourcePasswordManagementService.JsonBackedAccount(email=" + this.email + ", password=" + this.password + ", phone=" + this.phone + ", status=" + this.status + ", securityQuestions=" + this.securityQuestions + ")";
        }
    }
}

