/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.syncope.client.console.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.wizards.mapping.AbstractMappingPanel;
import org.apache.syncope.client.console.wizards.mapping.ItemTransformersTogglePanel;
import org.apache.syncope.client.console.wizards.mapping.JEXLTransformersTogglePanel;
import org.apache.syncope.client.console.wizards.resources.ResourceProvision;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.MappingPurpose;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceMappingPanel
extends AbstractMappingPanel {
    private static final long serialVersionUID = -7982691107029848579L;
    protected static final Logger LOG = LoggerFactory.getLogger(ResourceMappingPanel.class);
    @SpringBean
    protected ConnectorRestClient connectorRestClient;
    @SpringBean
    protected AnyTypeRestClient anyTypeRestClient;
    @SpringBean
    protected AnyTypeClassRestClient anyTypeClassRestClient;
    protected final ResourceProvision provision;
    protected final LoadableDetachableModel<List<String>> extAttrNames;

    public ResourceMappingPanel(String id, final ResourceTO resourceTO, final String adminRealm, final ResourceProvision provision, ItemTransformersTogglePanel itemTransformers, JEXLTransformersTogglePanel jexlTransformers) {
        super(id, itemTransformers, jexlTransformers, (IModel)new ListModel(provision.getItems()), resourceTO.getConnector() != null, MappingPurpose.BOTH);
        this.setOutputMarkupId(true);
        this.provision = provision;
        this.extAttrNames = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return ResourceMappingPanel.this.connectorRestClient.getExtAttrNames(adminRealm, provision.getObjectClass(), resourceTO.getConnector(), resourceTO.getConfOverride());
            }
        };
    }

    protected boolean hidePassword() {
        return !AnyTypeKind.USER.name().equals(this.provision.getAnyType());
    }

    protected IModel<List<String>> getExtAttrNames() {
        return this.extAttrNames;
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.passwordLabel.setVisible(AnyTypeKind.USER.name().equals(this.provision.getAnyType()));
    }

    protected void setAttrNames(AjaxTextFieldPanel toBeUpdated) {
        toBeUpdated.setRequired(true);
        toBeUpdated.setEnabled(true);
        HashSet<String> choices = new HashSet<String>();
        if ("REALM".equals(this.provision.getAnyType())) {
            choices.add("key");
            choices.add("name");
            choices.add("fullpath");
        } else {
            AnyTypeTO anyType = null;
            try {
                anyType = this.anyTypeRestClient.read(this.provision.getAnyType());
            }
            catch (Exception e) {
                LOG.error("Could not read AnyType {}", (Object)this.provision.getAnyType(), (Object)e);
            }
            ArrayList anyTypeClassTOs = new ArrayList();
            if (anyType != null) {
                try {
                    anyTypeClassTOs.addAll(this.anyTypeClassRestClient.list((Collection)anyType.getClasses()));
                }
                catch (Exception e) {
                    LOG.error("Could not read AnyType classes for {}", (Object)anyType.getClasses(), (Object)e);
                }
            }
            this.provision.getAuxClasses().forEach(auxClass -> {
                try {
                    anyTypeClassTOs.add(this.anyTypeClassRestClient.read(auxClass));
                }
                catch (Exception e) {
                    LOG.error("Could not read AnyTypeClass for {}", auxClass, (Object)e);
                }
            });
            switch (this.provision.getAnyType()) {
                case "USER": {
                    choices.addAll(ClassPathScanImplementationLookup.USER_FIELD_NAMES);
                    break;
                }
                case "GROUP": {
                    choices.addAll(ClassPathScanImplementationLookup.GROUP_FIELD_NAMES);
                    break;
                }
                default: {
                    choices.addAll(ClassPathScanImplementationLookup.ANY_OBJECT_FIELD_NAMES);
                }
            }
            anyTypeClassTOs.forEach(anyTypeClassTO -> {
                choices.addAll(anyTypeClassTO.getPlainSchemas());
                choices.addAll(anyTypeClassTO.getDerSchemas());
                choices.addAll(anyTypeClassTO.getVirSchemas());
            });
        }
        ArrayList names = new ArrayList(choices);
        Collections.sort(names);
        toBeUpdated.setChoices(names);
    }
}

