/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import org.apache.openjpa.persistence.OpenJPAEnum;
import org.apache.openjpa.persistence.jdbc.IsolationLevel;

public enum LRSSizeAlgorithm implements OpenJPAEnum<Enum<?>>
{
    UNKNOWN(0, "unknown"),
    LAST(1, "last"),
    QUERY(2, "query");

    private final int lrsConstant;
    private final String[] _names;

    private LRSSizeAlgorithm(int value, String ... aliases) {
        this.lrsConstant = value;
        this._names = aliases;
    }

    public int toKernelConstant() {
        return this.lrsConstant;
    }

    static LRSSizeAlgorithm fromKernelConstant(int kernelConstant) {
        switch (kernelConstant) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return LAST;
            }
            case 2: {
                return QUERY;
            }
        }
        throw new IllegalArgumentException(kernelConstant + "");
    }

    public int convertToKernelConstant(String s) {
        return LRSSizeAlgorithm.toKernelConstantFromString(s);
    }

    public int convertToKernelConstant(int i) {
        try {
            if (i == -99) {
                return i;
            }
            return LRSSizeAlgorithm.values()[i].ordinal();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(i + " is invalid value for LRSSize Algorithm");
        }
    }

    public static int toKernelConstantFromString(String s) {
        for (LRSSizeAlgorithm level : LRSSizeAlgorithm.values()) {
            for (String name : level._names) {
                if (!name.equalsIgnoreCase(s) && !String.valueOf(level.toKernelConstant()).equals(s)) continue;
                return level.toKernelConstant();
            }
        }
        throw new IllegalArgumentException(s + " is not a valid name for " + IsolationLevel.class.getName());
    }
}

