/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.core.textstats;

import org.apache.lucene.util.PriorityQueue;
import org.apache.tika.eval.core.tokens.TokenIntPair;

public class TokenCountPriorityQueue
extends PriorityQueue<TokenIntPair> {
    public TokenCountPriorityQueue(int maxSize) {
        super(maxSize);
    }

    @Override
    protected boolean lessThan(TokenIntPair arg0, TokenIntPair arg1) {
        if (arg0.getValue() < arg1.getValue()) {
            return true;
        }
        if (arg0.getValue() > arg1.getValue()) {
            return false;
        }
        return arg1.getToken().compareTo(arg0.getToken()) < 0;
    }

    public TokenIntPair[] getArray() {
        TokenIntPair[] topN = new TokenIntPair[this.size()];
        TokenIntPair term = (TokenIntPair)this.pop();
        int i = topN.length - 1;
        while (term != null && i > -1) {
            topN[i--] = term;
            term = (TokenIntPair)this.pop();
        }
        return topN;
    }
}

