/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.core.tokens;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.custom.CustomAnalyzer;
import org.apache.lucene.util.ClasspathResourceLoader;

class AnalyzerDeserializer {
    private static final String ANALYZERS = "analyzers";
    private static final String CHAR_FILTERS = "charfilters";
    private static final String TOKEN_FILTERS = "tokenfilters";
    private static final String TOKENIZER = "tokenizer";
    private static final String FACTORY = "factory";
    private static final String PARAMS = "params";
    private static final String COMMENT = "_comment";

    AnalyzerDeserializer() {
    }

    public static Map<String, Analyzer> buildAnalyzers(Reader reader, int maxTokens) throws IOException {
        JsonNode root = new ObjectMapper().readTree(reader);
        HashMap<String, Analyzer> analyzers = new HashMap<String, Analyzer>();
        if (!root.isObject() || root.get(ANALYZERS) == null) {
            throw new IllegalArgumentException("root object must be object with an 'analyzers' element");
        }
        for (Map.Entry<String, JsonNode> e : root.get(ANALYZERS).properties()) {
            String analyzerName = e.getKey();
            Analyzer analyzer = AnalyzerDeserializer.buildAnalyzer(analyzerName, e.getValue(), maxTokens);
            analyzers.put(analyzerName, analyzer);
        }
        return analyzers;
    }

    public static Analyzer buildAnalyzer(String analyzerName, JsonNode node, int maxTokens) throws IOException {
        if (!node.isObject()) {
            throw new IllegalArgumentException("Expecting map of charfilter, tokenizer, tokenfilters");
        }
        CustomAnalyzer.Builder builder = CustomAnalyzer.builder(new ClasspathResourceLoader(AnalyzerDeserializer.class));
        for (Map.Entry<String, JsonNode> e : node.properties()) {
            String k = e.getKey();
            if (k.equals(CHAR_FILTERS)) {
                AnalyzerDeserializer.buildCharFilters(e.getValue(), analyzerName, builder);
                continue;
            }
            if (k.equals(TOKEN_FILTERS)) {
                AnalyzerDeserializer.buildTokenFilterFactories(e.getValue(), analyzerName, maxTokens, builder);
                continue;
            }
            if (k.equals(TOKENIZER)) {
                AnalyzerDeserializer.buildTokenizerFactory(e.getValue(), analyzerName, builder);
                continue;
            }
            if (k.equals(COMMENT)) continue;
            throw new IllegalArgumentException("Should have one of three values here:charfilters, tokenizer, tokenfilters. I don't recognize: " + k);
        }
        return builder.build();
    }

    private static void buildTokenizerFactory(JsonNode map, String analyzerName, CustomAnalyzer.Builder builder) throws IOException {
        if (!map.isObject()) {
            throw new IllegalArgumentException("Expecting a map with \"factory\" string and \"params\" map in tokenizer factory; not: " + map.toString() + " in " + analyzerName);
        }
        JsonNode factoryEl = map.get(FACTORY);
        if (factoryEl == null || !factoryEl.isTextual()) {
            throw new IllegalArgumentException("Expecting value for factory in char filter factory builder in:" + analyzerName);
        }
        String factoryName = factoryEl.asText();
        factoryName = factoryName.startsWith("oala.") ? factoryName.replaceFirst("oala.", "org.apache.lucene.analysis.") : factoryName;
        JsonNode paramsEl = map.get(PARAMS);
        Map<String, String> params = AnalyzerDeserializer.mapify(paramsEl);
        builder.withTokenizer(factoryName, params);
    }

    private static void buildCharFilters(JsonNode el, String analyzerName, CustomAnalyzer.Builder builder) throws IOException {
        if (el == null || el.isNull()) {
            return;
        }
        if (!el.isArray()) {
            throw new IllegalArgumentException("Expecting array for charfilters, but got:" + el.toString() + " for " + analyzerName);
        }
        for (JsonNode filterMap : el) {
            if (!filterMap.isObject()) {
                throw new IllegalArgumentException("Expecting a map with \"factory\" string and \"params\" map in char filter factory; not: " + filterMap.toString() + " in " + analyzerName);
            }
            JsonNode factoryEl = filterMap.get(FACTORY);
            if (factoryEl == null || !factoryEl.isTextual()) {
                throw new IllegalArgumentException("Expecting value for factory in char filter factory builder in:" + analyzerName);
            }
            String factoryName = factoryEl.asText();
            factoryName = factoryName.replaceAll("oala.", "org.apache.lucene.analysis.");
            JsonNode paramsEl = filterMap.get(PARAMS);
            Map<String, String> params = AnalyzerDeserializer.mapify(paramsEl);
            builder.addCharFilter(factoryName, params);
        }
    }

    private static void buildTokenFilterFactories(JsonNode el, String analyzerName, int maxTokens, CustomAnalyzer.Builder builder) throws IOException {
        if (el == null || el.isNull()) {
            return;
        }
        if (!el.isArray()) {
            throw new IllegalArgumentException("Expecting array for tokenfilters, but got:" + el.toString() + " in " + analyzerName);
        }
        for (JsonNode filterMap : el) {
            if (!filterMap.isObject()) {
                throw new IllegalArgumentException("Expecting a map with \"factory\" string and \"params\" map in token filter factory; not: " + filterMap.toString() + " in " + analyzerName);
            }
            JsonNode factoryEl = filterMap.get(FACTORY);
            if (factoryEl == null || !factoryEl.isTextual()) {
                throw new IllegalArgumentException("Expecting value for factory in token filter factory builder in " + analyzerName);
            }
            String factoryName = factoryEl.asText();
            factoryName = factoryName.startsWith("oala.") ? factoryName.replaceFirst("oala.", "org.apache.lucene.analysis.") : factoryName;
            JsonNode paramsEl = filterMap.get(PARAMS);
            Map<String, String> params = AnalyzerDeserializer.mapify(paramsEl);
            builder.addTokenFilter(factoryName, params);
        }
        if (maxTokens > -1) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("maxTokenCount", Integer.toString(maxTokens));
            builder.addTokenFilter("limittokencount", m);
        }
    }

    private static Map<String, String> mapify(JsonNode paramsEl) {
        if (paramsEl == null || paramsEl.isNull()) {
            return Collections.EMPTY_MAP;
        }
        if (!paramsEl.isObject()) {
            throw new IllegalArgumentException("Expecting map, not: " + paramsEl.toString());
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, JsonNode> e : paramsEl.properties()) {
            JsonNode value = e.getValue();
            if (value.isObject() || value.isArray() || value.isNull()) {
                throw new IllegalArgumentException("Expecting parameter to have primitive value: " + value.toString());
            }
            String v = e.getValue().asText();
            params.put(e.getKey(), v);
        }
        return params;
    }
}

