/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser.xref;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.pdfparser.xref.AbstractXReference;
import org.apache.pdfbox.pdfparser.xref.XReferenceType;

public class ObjectStreamXReference
extends AbstractXReference {
    private final int objectStreamIndex;
    private final COSObjectKey key;
    private final COSBase object;
    private final COSObjectKey parentKey;

    public ObjectStreamXReference(int objectStreamIndex, COSObjectKey key, COSBase object, COSObjectKey parentKey) {
        super(XReferenceType.OBJECT_STREAM_ENTRY);
        this.objectStreamIndex = objectStreamIndex;
        this.key = key;
        this.object = object;
        this.parentKey = parentKey;
    }

    public int getObjectStreamIndex() {
        return this.objectStreamIndex;
    }

    @Override
    public COSObjectKey getReferencedKey() {
        return this.key;
    }

    public COSBase getObject() {
        return this.object;
    }

    public COSObjectKey getParentKey() {
        return this.parentKey;
    }

    @Override
    public long getSecondColumnValue() {
        return this.getParentKey().getNumber();
    }

    @Override
    public long getThirdColumnValue() {
        return this.getObjectStreamIndex();
    }

    public String toString() {
        return "ObjectStreamEntry{ key=" + this.key + ", type=" + this.getType().getNumericValue() + ", objectStreamIndex=" + this.objectStreamIndex + ", parent=" + this.parentKey + " }";
    }
}

