/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.io.Serializable;
import java.util.Map;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public final class PixelTranslation
extends Static
implements Serializable {
    private static final long serialVersionUID = -5671620211497720808L;
    private static final MathTransform[] translations = new MathTransform[10];
    public final PixelOrientation orientation;
    public final double dx;
    public final double dy;
    private static final Map<PixelOrientation, PixelTranslation> ORIENTATIONS = Map.ofEntries(PixelTranslation.entry(PixelOrientation.CENTER, 0.0, 0.0), PixelTranslation.entry(PixelOrientation.UPPER_LEFT, -0.5, -0.5), PixelTranslation.entry(PixelOrientation.UPPER_RIGHT, 0.5, -0.5), PixelTranslation.entry(PixelOrientation.LOWER_LEFT, -0.5, 0.5), PixelTranslation.entry(PixelOrientation.LOWER_RIGHT, 0.5, 0.5));

    private static Map.Entry<PixelOrientation, PixelTranslation> entry(PixelOrientation orientation, double dx, double dy) {
        return Map.entry(orientation, new PixelTranslation(orientation, dx, dy));
    }

    private PixelTranslation(PixelOrientation orientation, double dx, double dy) {
        this.orientation = orientation;
        this.dx = dx;
        this.dy = dy;
    }

    public static PixelOrientation getPixelOrientation(PixelInCell anchor) {
        if (anchor == null) {
            return null;
        }
        if (anchor.equals(PixelInCell.CELL_CENTER)) {
            return PixelOrientation.CENTER;
        }
        if (anchor.equals(PixelInCell.CELL_CORNER)) {
            return PixelOrientation.UPPER_LEFT;
        }
        throw new IllegalArgumentException(Errors.format((short)45, "anchor", anchor));
    }

    public static double getPixelTranslation(PixelInCell anchor) {
        if (PixelInCell.CELL_CENTER.equals(anchor)) {
            return 0.0;
        }
        if (PixelInCell.CELL_CORNER.equals(anchor)) {
            return -0.5;
        }
        throw new IllegalArgumentException(Errors.format((short)45, "anchor", anchor));
    }

    public static PixelTranslation getPixelTranslation(PixelOrientation anchor) {
        PixelTranslation offset = ORIENTATIONS.get(anchor);
        if (offset == null) {
            throw new IllegalArgumentException(Errors.format((short)45, "anchor", anchor));
        }
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MathTransform translate(MathTransform gridToCRS, PixelInCell current, PixelInCell desired) {
        MathTransform mt;
        if (gridToCRS == null || desired.equals(current)) {
            return gridToCRS;
        }
        int dimension = gridToCRS.getSourceDimensions();
        double offset = PixelTranslation.getPixelTranslation(desired) - PixelTranslation.getPixelTranslation(current);
        int ci = offset == -0.5 ? 2 * dimension - 2 : (offset == 0.5 ? 2 * dimension - 1 : -1);
        if (ci < 0 || ci >= translations.length) {
            mt = MathTransforms.uniformTranslation(dimension, offset);
            return MathTransforms.concatenate(mt, gridToCRS);
        }
        MathTransform[] mathTransformArray = translations;
        synchronized (translations) {
            mt = translations[ci];
            if (mt != null) return MathTransforms.concatenate(mt, gridToCRS);
            mt = MathTransforms.uniformTranslation(dimension, offset);
            PixelTranslation.translations[ci] = mt;
            // ** MonitorExit[var8_7] (shouldn't be in output)
            return MathTransforms.concatenate(mt, gridToCRS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MathTransform translate(MathTransform gridToCRS, PixelOrientation current, PixelOrientation desired, int xDimension, int yDimension) {
        MathTransform mt;
        if (gridToCRS == null || desired.equals(current)) {
            return gridToCRS;
        }
        int dimension = gridToCRS.getSourceDimensions();
        if (xDimension < 0 || xDimension >= dimension) {
            throw PixelTranslation.illegalDimension("xDimension", xDimension);
        }
        if (yDimension < 0 || yDimension >= dimension) {
            throw PixelTranslation.illegalDimension("yDimension", yDimension);
        }
        if (xDimension == yDimension) {
            throw PixelTranslation.illegalDimension("xDimension", "yDimension");
        }
        PixelTranslation source = PixelTranslation.getPixelTranslation(current);
        PixelTranslation target = PixelTranslation.getPixelTranslation(desired);
        double dx = target.dx - source.dx;
        double dy = target.dy - source.dy;
        if (dimension == 2 && (xDimension | yDimension) == 1 && dx == dy && Math.abs(dx) == 0.5) {
            int ci = dx >= 0.0 ? 3 : 2;
            MathTransform[] mathTransformArray = translations;
            synchronized (translations) {
                mt = translations[ci];
                if (mt == null) {
                    mt = MathTransforms.uniformTranslation(dimension, dx);
                    PixelTranslation.translations[ci] = mt;
                }
                // ** MonitorExit[var14_12] (shouldn't be in output)
            }
        } else {
            MatrixSIS matrix = Matrices.createIdentity(dimension + 1);
            matrix.setElement(xDimension, dimension, dx);
            matrix.setElement(yDimension, dimension, dy);
            mt = MathTransforms.linear(matrix);
        }
        return MathTransforms.concatenate(mt, gridToCRS);
    }

    private static IllegalArgumentException illegalDimension(String name, Object dimension) {
        return new IllegalArgumentException(Errors.format((short)45, name, dimension));
    }

    public String toString() {
        return String.valueOf(this.orientation) + "[" + this.dx + ", " + this.dy + "]";
    }
}

