/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.util.function.Consumer;
import javax.measure.Quantity;
import org.apache.sis.coverage.grid.j2d.ImageLayout;
import org.apache.sis.coverage.grid.j2d.ImageUtilities;
import org.apache.sis.coverage.grid.j2d.TileOpExecutor;
import org.apache.sis.image.ComputedImage;
import org.apache.sis.image.DataType;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.Interpolation;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.operation.MathTransform;

public class ImageCombiner
implements Consumer<RenderedImage> {
    private final ImageProcessor processor;
    private final WritableRenderedImage destination;

    public ImageCombiner(WritableRenderedImage destination) {
        this(destination, new ImageProcessor());
    }

    public ImageCombiner(WritableRenderedImage destination, ImageProcessor processor) {
        ArgumentChecks.ensureNonNull("destination", destination);
        ArgumentChecks.ensureNonNull("processor", processor);
        this.destination = destination;
        this.processor = processor;
    }

    public Interpolation getInterpolation() {
        return this.processor.getInterpolation();
    }

    public void setInterpolation(Interpolation method) {
        this.processor.setInterpolation(method);
    }

    public Quantity<?>[] getPositionalAccuracyHints() {
        return this.processor.getPositionalAccuracyHints();
    }

    public void setPositionalAccuracyHints(Quantity<?> ... hints) {
        this.processor.setPositionalAccuracyHints(hints);
    }

    public DataType getBandType() {
        return DataType.forBands(this.destination);
    }

    @Override
    public void accept(RenderedImage source) {
        ArgumentChecks.ensureNonNull("source", source);
        final WritableRenderedImage destination = this.destination;
        Rectangle bounds = ImageUtilities.getBounds(source);
        ImageUtilities.clipBounds(destination, bounds);
        if (!bounds.isEmpty()) {
            TileOpExecutor executor = new TileOpExecutor(source, bounds){

                @Override
                protected void readFrom(Raster tile) {
                    destination.setData(tile);
                }
            };
            executor.readFrom(this.processor.prefetch(source, bounds));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resample(RenderedImage source, Rectangle bounds, MathTransform toSource) {
        RenderedImage result;
        ArgumentChecks.ensureNonNull("source", source);
        ArgumentChecks.ensureNonNull("toSource", toSource);
        if (bounds == null) {
            bounds = ImageUtilities.getBounds(this.destination);
        }
        int tileWidth = this.destination.getTileWidth();
        int tileHeight = this.destination.getTileHeight();
        long tileGridXOffset = this.destination.getTileGridXOffset();
        long tileGridYOffset = this.destination.getTileGridYOffset();
        int minTileX = Math.toIntExact(Math.floorDiv((long)bounds.x - tileGridXOffset, tileWidth));
        int minTileY = Math.toIntExact(Math.floorDiv((long)bounds.y - tileGridYOffset, tileHeight));
        int minX = Math.toIntExact(Math.multiplyFull(minTileX, tileWidth) + tileGridXOffset);
        int minY = Math.toIntExact(Math.multiplyFull(minTileY, tileHeight) + tileGridYOffset);
        long maxX = (long)bounds.x + (long)bounds.width - 1L;
        long maxY = (long)bounds.y + (long)bounds.height - 1L;
        maxX = ((maxX - tileGridXOffset) / (long)tileWidth + 1L) * (long)tileWidth + tileGridXOffset;
        maxY = ((maxY - tileGridYOffset) / (long)tileHeight + 1L) * (long)tileHeight + tileGridYOffset;
        bounds = new Rectangle(minX, minY, Math.toIntExact(maxX - (long)minX), Math.toIntExact(maxY - (long)minY));
        ImageProcessor imageProcessor = this.processor;
        synchronized (imageProcessor) {
            ImageLayout layout = ImageLayout.forDestination(this.destination, minTileX, minTileY);
            ImageLayout previous = this.processor.getImageLayout();
            try {
                this.processor.setImageLayout(layout);
                result = this.processor.resample(source, bounds, toSource);
            }
            finally {
                this.processor.setImageLayout(previous);
            }
        }
        if (result instanceof ComputedImage && ((ComputedImage)result).getDestination() == this.destination) {
            this.processor.prefetch(result, ImageUtilities.getBounds(this.destination));
        } else {
            this.accept(result);
        }
    }

    public RenderedImage result() {
        return this.destination;
    }
}

