/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.gml;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.sis.pending.geoapi.temporal.Instant;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.gml.GMLAdapter;
import org.apache.sis.xml.util.XmlUtilities;

@XmlType(name="TimeInstantType")
@XmlRootElement(name="TimeInstant")
public final class TimeInstant
extends GMLAdapter {
    @XmlElement
    public XMLGregorianCalendar timePosition;

    public TimeInstant() {
    }

    public TimeInstant(Instant instant) {
        this.timePosition = TimeInstant.toXML(instant);
    }

    static XMLGregorianCalendar toXML(Instant instant) {
        Date date;
        if (instant != null && (date = instant.getDate()) != null) {
            Context context = Context.current();
            try {
                XMLGregorianCalendar gc = XmlUtilities.toXML(context, date);
                if (gc != null) {
                    XmlUtilities.trimTime(gc, false);
                    return gc;
                }
            }
            catch (DatatypeConfigurationException e) {
                Context.warningOccured(context, TimeInstant.class, "toXML", e, true);
            }
        }
        return null;
    }

    public String toString() {
        return Strings.bracket(this.getClass(), (Object)this.timePosition);
    }
}

