/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvMetadata;
import thredds.catalog.InvService;
import thredds.catalog.ThreddsMetadata;
import thredds.cataloggen.config.DatasetSource;
import thredds.cataloggen.config.DatasetSourceType;
import thredds.util.DodsURLExtractor;

public class DodsDirDatasetSource
extends DatasetSource {
    private static Logger log = LoggerFactory.getLogger(DodsDirDatasetSource.class);
    private URI accessPointHeaderUri = null;
    private DodsURLExtractor urlExtractor = null;

    public DodsDirDatasetSource() {
        this.type = DatasetSourceType.getType("DodsDir");
        this.urlExtractor = new DodsURLExtractor();
    }

    @Override
    protected InvDataset createDataset(String datasetLocation, String prefixUrlPath) throws IOException {
        URI dsLocUri = null;
        try {
            dsLocUri = new URI(datasetLocation);
        }
        catch (URISyntaxException e) {
            throw new IOException("URISyntaxException for dataset location <" + datasetLocation + ">: " + e.getMessage());
        }
        return new DodsDirInvDataset(null, dsLocUri);
    }

    @Override
    protected InvCatalog createSkeletonCatalog(String prefixUrlPath) throws IOException {
        String aphString = this.getResultService().getAccessPointHeader();
        String apString = this.getAccessPoint();
        if (!apString.startsWith(aphString)) {
            throw new IOException("The accessPoint <" + apString + "> must start with the accessPointHeader <" + aphString + ">.");
        }
        if (!apString.endsWith("/")) {
            throw new IOException("The accessPoint URL must end with a \"/\" <" + apString + ">.");
        }
        String apVersionString = apString + "version";
        String apVersionResultContent = null;
        try {
            apVersionResultContent = this.urlExtractor.getTextContent(apVersionString);
        }
        catch (IOException e) {
            String tmpMsg = "The accessPoint URL is not an OPeNDAP server URL (no version info) <" + apVersionString + ">";
            log.error("expandThisType(): " + tmpMsg, e);
            IOException myE = new IOException(tmpMsg + e.getMessage());
            myE.initCause(e);
            throw myE;
        }
        if (apVersionResultContent.indexOf("DODS") == -1 && apVersionResultContent.indexOf("OPeNDAP") == -1 && apVersionResultContent.indexOf("DAP") == -1) {
            String tmpMsg = "The accessPoint URL version info is not valid <" + apVersionResultContent + ">";
            log.error("expandThisType(): " + tmpMsg);
            throw new IOException(tmpMsg);
        }
        try {
            this.accessPointHeaderUri = new URI(aphString);
        }
        catch (URISyntaxException e) {
            throw new IOException("The accessPointHeader URL failed to map to a URI <" + aphString + ">.");
        }
        InvCatalogImpl catalog = new InvCatalogImpl(null, null, null);
        InvService service = new InvService(this.getResultService().getName(), this.getResultService().getServiceType().toString(), this.getResultService().getBase(), this.getResultService().getSuffix(), this.getResultService().getDescription());
        Iterator<Object> it = this.getResultService().getProperties().iterator();
        while (it.hasNext()) {
            service.addProperty(it.next());
        }
        it = this.getResultService().getServices().iterator();
        while (it.hasNext()) {
            service.addService((InvService)it.next());
        }
        catalog.addService(service);
        DodsDirInvDataset topDs = null;
        try {
            topDs = new DodsDirInvDataset(null, new URI(apString));
        }
        catch (URISyntaxException e) {
            throw new IOException("The accessPoint URL failed to map to a URI <" + apString + ">.");
        }
        ThreddsMetadata tm = new ThreddsMetadata(false);
        tm.setServiceName(service.getName());
        InvMetadata md = new InvMetadata(topDs, null, "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "", true, true, null, tm);
        ThreddsMetadata tm2 = new ThreddsMetadata(false);
        tm2.addMetadata(md);
        topDs.setLocalMetadata(tm2);
        catalog.addDataset(topDs);
        catalog.finish();
        return catalog;
    }

    @Override
    protected boolean isCollection(InvDataset dataset) {
        return ((DodsDirInvDataset)dataset).isDirectory();
    }

    @Override
    protected List expandThisLevel(InvDataset dataset, String prefixUrlPath) {
        if (dataset == null) {
            throw new NullPointerException("Given dataset cannot be null.");
        }
        if (!this.isCollection(dataset)) {
            throw new IllegalArgumentException("Dataset \"" + dataset.getName() + "\" is not a collection dataset.");
        }
        ArrayList<DodsDirInvDataset> dsList = new ArrayList<DodsDirInvDataset>();
        ArrayList possibleDsList = null;
        try {
            possibleDsList = this.urlExtractor.extract(dataset.getName());
        }
        catch (IOException e) {
            log.warn("expandThisLevel(): IOException while extracting dataset info from given OPeNDAP directory <" + dataset.getName() + ">, return empty list: " + e.getMessage());
            return dsList;
        }
        String curDsUrlString2 = null;
        URI curDsUri = null;
        DodsDirInvDataset curDs = null;
        for (String curDsUrlString2 : possibleDsList) {
            if (!curDsUrlString2.endsWith(".html") && !curDsUrlString2.endsWith("/")) {
                log.warn("expandThisLevel(): Dataset isn't an OPeNDAP dataset or collection dataset, skip <" + dataset.getName() + ">.");
                continue;
            }
            if (curDsUrlString2.endsWith(".html")) {
                curDsUrlString2 = curDsUrlString2.substring(0, curDsUrlString2.length() - 5);
            }
            if (!curDsUrlString2.startsWith(this.accessPointHeaderUri.toString())) {
                log.debug("expandThisLevel(): current path <" + curDsUrlString2 + "> not child of given" + " location <" + this.accessPointHeaderUri.toString() + ">, skip.");
                continue;
            }
            try {
                curDsUri = new URI(curDsUrlString2);
            }
            catch (URISyntaxException e) {
                log.error("expandThisLevel(): Skipping dataset  <" + curDsUrlString2 + "> due to URISyntaxException: " + e.getMessage());
                continue;
            }
            log.debug("expandThisLevel(): handle dataset (" + curDsUrlString2 + ")");
            try {
                curDs = new DodsDirInvDataset(null, curDsUri);
            }
            catch (IOException e) {
                log.warn("expandThisLevel(): skipping dataset <" + curDsUri.toString() + ">, not under accessPointHeader: " + e.getMessage());
                continue;
            }
            dsList.add(curDs);
        }
        return dsList;
    }

    private class DodsDirInvDataset
    extends InvDatasetImpl {
        private URI uri;
        private boolean directory;

        DodsDirInvDataset(InvDataset parent, URI uri) throws IOException {
            super((InvDatasetImpl)parent, null, null, null, null);
            this.uri = null;
            this.directory = false;
            this.uri = uri;
            this.directory = uri.toString().endsWith("/");
            String dsAbsolutePath = uri.toString();
            String dsRelativePath = null;
            if (!dsAbsolutePath.startsWith(DodsDirDatasetSource.this.accessPointHeaderUri.toString())) {
                throw new IOException("URI <" + dsAbsolutePath + "> not under accessPointHeader directory <" + DodsDirDatasetSource.this.accessPointHeaderUri.toString() + ">.");
            }
            dsRelativePath = dsAbsolutePath.substring(DodsDirDatasetSource.this.accessPointHeaderUri.toString().length());
            if (!this.directory) {
                this.setUrlPath(dsRelativePath);
            }
            this.setName(dsRelativePath);
        }

        URI getUri() {
            return this.uri;
        }

        void setUri(URI uri) {
            this.uri = uri;
        }

        boolean isDirectory() {
            return this.directory;
        }
    }
}

