/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.geopkg;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tika.config.Field;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.geopkg.GeoPkgDBParser;
import org.apache.tika.parser.sqlite3.SQLite3Parser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class GeoPkgParser
extends SQLite3Parser {
    private static final long serialVersionUID = -752276948656079347L;
    private static final MediaType MEDIA_TYPE = MediaType.application((String)"x-geopackage");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MEDIA_TYPE);
    private static final Set<String> DEFAULT_IGNORE_BLOB_COLUMNS = Set.of("geom", "data");
    private Set<String> ignoreBlobColumns = new HashSet<String>(DEFAULT_IGNORE_BLOB_COLUMNS);

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        GeoPkgDBParser p = new GeoPkgDBParser(this.ignoreBlobColumns);
        p.parse(stream, handler, metadata, context);
    }

    @Field
    public void setIgnoreBlobColumns(List<String> ignoreBlobColumns) {
        this.ignoreBlobColumns.clear();
        this.ignoreBlobColumns.addAll(ignoreBlobColumns);
    }

    @Override
    public void initialize(Map<String, Param> params) throws TikaConfigException {
    }

    @Override
    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
    }
}

