/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.time.Year;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class SingleTypeSerializer<T>
extends SimpleTypeSerializer<T> {
    public static final SingleTypeSerializer<Integer> IntSerializer = new SingleTypeSerializer<Integer>(DataType.INT, Buffer::readInt, (v, b) -> b.writeInt((int)v));
    public static final SingleTypeSerializer<Long> LongSerializer = new SingleTypeSerializer<Long>(DataType.LONG, Buffer::readLong, (v, b) -> b.writeLong((long)v));
    public static final SingleTypeSerializer<Double> DoubleSerializer = new SingleTypeSerializer<Double>(DataType.DOUBLE, Buffer::readDouble, (v, b) -> b.writeDouble((double)v));
    public static final SingleTypeSerializer<Float> FloatSerializer = new SingleTypeSerializer<Float>(DataType.FLOAT, Buffer::readFloat, (v, b) -> b.writeFloat(v.floatValue()));
    public static final SingleTypeSerializer<Short> ShortSerializer = new SingleTypeSerializer<Short>(DataType.SHORT, Buffer::readShort, (v, b) -> b.writeShort(v.shortValue()));
    public static final SingleTypeSerializer<Boolean> BooleanSerializer = new SingleTypeSerializer<Boolean>(DataType.BOOLEAN, Buffer::readBoolean, (v, b) -> b.writeBoolean((boolean)v));
    public static final SingleTypeSerializer<Byte> ByteSerializer = new SingleTypeSerializer<Byte>(DataType.BYTE, Buffer::readByte, (v, b) -> b.writeByte(v.byteValue()));
    public static final SingleTypeSerializer<Year> YearSerializer = new SingleTypeSerializer<Year>(DataType.YEAR, bb -> Year.of(bb.readInt()), (v, b) -> b.writeInt(v.getValue()));
    private final Function<Buffer, T> readFunc;
    private final BiConsumer<T, Buffer> writeFunc;

    private SingleTypeSerializer(DataType dataType, Function<Buffer, T> readFunc, BiConsumer<T, Buffer> writeFunc) {
        super(dataType);
        this.readFunc = readFunc;
        this.writeFunc = writeFunc;
    }

    @Override
    public T readValue(Buffer buffer, GraphBinaryReader context) {
        return this.readFunc.apply(buffer);
    }

    @Override
    protected void writeValue(T value, Buffer buffer, GraphBinaryWriter context) {
        this.writeFunc.accept(value, buffer);
    }
}

