/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.cdi;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.security.enterprise.authentication.mechanism.http.BasicAuthenticationMechanismDefinition;
import jakarta.security.enterprise.authentication.mechanism.http.CustomFormAuthenticationMechanismDefinition;
import jakarta.security.enterprise.authentication.mechanism.http.FormAuthenticationMechanismDefinition;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.LoginToContinue;
import jakarta.security.enterprise.authentication.mechanism.http.OpenIdAuthenticationMechanismDefinition;
import jakarta.security.enterprise.identitystore.DatabaseIdentityStoreDefinition;
import jakarta.security.enterprise.identitystore.IdentityStore;
import jakarta.security.enterprise.identitystore.LdapIdentityStoreDefinition;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.tomee.security.TomEEELInvocationHandler;
import org.apache.tomee.security.TomEEPbkdf2PasswordHash;
import org.apache.tomee.security.TomEEPlaintextPasswordHash;
import org.apache.tomee.security.TomEESecurityContext;
import org.apache.tomee.security.cdi.AutoApplySessionInterceptor;
import org.apache.tomee.security.cdi.BasicAuthenticationMechanism;
import org.apache.tomee.security.cdi.CustomFormAuthenticationMechanism;
import org.apache.tomee.security.cdi.DefaultAuthenticationMechanism;
import org.apache.tomee.security.cdi.FormAuthenticationMechanism;
import org.apache.tomee.security.cdi.LoginToContinueInterceptor;
import org.apache.tomee.security.cdi.OpenIdAuthenticationMechanism;
import org.apache.tomee.security.cdi.RememberMeInterceptor;
import org.apache.tomee.security.cdi.TomEESecurityServletAuthenticationMechanismMapper;
import org.apache.tomee.security.cdi.TomcatUserIdentityStoreDefinition;
import org.apache.tomee.security.cdi.openid.BaseUrlProducer;
import org.apache.tomee.security.cdi.openid.OpenIdIdentityStore;
import org.apache.tomee.security.cdi.openid.TomEEOpenIdContext;
import org.apache.tomee.security.cdi.openid.storage.OpenIdStorageHandler;
import org.apache.tomee.security.cdi.openid.storage.impl.CookieBasedOpenIdStorageHandler;
import org.apache.tomee.security.cdi.openid.storage.impl.SessionBasedOpenIdStorageHandler;
import org.apache.tomee.security.http.openid.OpenIdAuthenticationMechanismDefinitionDelegate;
import org.apache.tomee.security.identitystore.TomEEDatabaseIdentityStore;
import org.apache.tomee.security.identitystore.TomEEDefaultIdentityStore;
import org.apache.tomee.security.identitystore.TomEEIdentityStoreHandler;
import org.apache.tomee.security.identitystore.TomEELDAPIdentityStore;

public class TomEESecurityExtension
implements Extension {
    private final AtomicReference<Annotated> basicMechanism = new AtomicReference();
    private final AtomicReference<Annotated> formMechanism = new AtomicReference();
    private final AtomicReference<Annotated> customMechanism = new AtomicReference();
    private final AtomicReference<Annotated> oidcMechanism = new AtomicReference();
    private final AtomicReference<Annotated> tomcatUserStore = new AtomicReference();
    private final AtomicReference<Annotated> databaseStore = new AtomicReference();
    private final AtomicReference<Annotated> ldapStore = new AtomicReference();
    private boolean applicationAuthenticationMechanisms = false;

    void observeBeforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(DefaultAuthenticationMechanism.class), "DefaultAuthenticationMechanism");
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(TomEESecurityServletAuthenticationMechanismMapper.class), "TomEESecurityServletAuthenticationMechanismMapper");
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(TomEEIdentityStoreHandler.class), "TomEEIdentityStoreHandler");
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(TomEEPbkdf2PasswordHash.class), "TomEEPbkdf2PasswordHash");
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(TomEEPlaintextPasswordHash.class), "TomEEPlaintextPasswordHash");
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(AutoApplySessionInterceptor.class), "AutoApplySessionInterceptor");
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(RememberMeInterceptor.class), "RememberMeInterceptor");
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(LoginToContinueInterceptor.class), "LoginToContinueInterceptor");
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(TomEESecurityContext.class), "TomEESecurityContext");
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(BaseUrlProducer.class), "TomEEBaseUrlProducer");
    }

    public <T> void processBean(@Observes ProcessBean<T> eventIn, BeanManager beanManager) {
        Annotated annotatedType = eventIn.getAnnotated();
        if (this.tomcatUserStore.get() == null && annotatedType.isAnnotationPresent(TomcatUserIdentityStoreDefinition.class)) {
            this.tomcatUserStore.set(annotatedType);
        }
        if (this.databaseStore.get() == null && annotatedType.isAnnotationPresent(DatabaseIdentityStoreDefinition.class)) {
            this.databaseStore.set(annotatedType);
        }
        if (this.ldapStore.get() == null && annotatedType.isAnnotationPresent(LdapIdentityStoreDefinition.class)) {
            this.ldapStore.set(annotatedType);
        }
        if (this.basicMechanism.get() == null && annotatedType.isAnnotationPresent(BasicAuthenticationMechanismDefinition.class)) {
            this.basicMechanism.set(annotatedType);
        }
        if (this.formMechanism.get() == null && annotatedType.isAnnotationPresent(FormAuthenticationMechanismDefinition.class)) {
            this.formMechanism.set(annotatedType);
        }
        if (this.customMechanism.get() == null && annotatedType.isAnnotationPresent(CustomFormAuthenticationMechanismDefinition.class)) {
            this.customMechanism.set(annotatedType);
        }
        if (this.oidcMechanism.get() == null && annotatedType.isAnnotationPresent(OpenIdAuthenticationMechanismDefinition.class)) {
            this.oidcMechanism.set(annotatedType);
        }
        if (eventIn.getBean().getTypes().contains(HttpAuthenticationMechanism.class)) {
            this.applicationAuthenticationMechanisms = true;
        }
    }

    void registerAuthenticationMechanism(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (this.tomcatUserStore.get() != null) {
            afterBeanDiscovery.addBean().id(TomEEDefaultIdentityStore.class.getName() + "#" + TomcatUserIdentityStoreDefinition.class.getName()).beanClass(Supplier.class).addType(Object.class).addType((TypeLiteral)new TypeLiteral<Supplier<TomcatUserIdentityStoreDefinition>>(){}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> this.createTomcatUserIdentityStoreDefinitionSupplier(beanManager));
            afterBeanDiscovery.addBean().id(TomEEDefaultIdentityStore.class.getName()).beanClass(TomEEDefaultIdentityStore.class).types(new Type[]{Object.class, IdentityStore.class, TomEEDefaultIdentityStore.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> {
                AnnotatedType annotatedType = beanManager.createAnnotatedType(TomEEDefaultIdentityStore.class);
                BeanAttributes beanAttributes = beanManager.createBeanAttributes(annotatedType);
                return (TomEEDefaultIdentityStore)beanManager.createBean(beanAttributes, TomEEDefaultIdentityStore.class, beanManager.getInjectionTargetFactory(annotatedType)).create(creationalContext);
            });
        }
        if (this.databaseStore.get() != null) {
            afterBeanDiscovery.addBean().id(TomEEDatabaseIdentityStore.class.getName() + "#" + DatabaseIdentityStoreDefinition.class.getName()).beanClass(Supplier.class).addType(Object.class).addType((TypeLiteral)new TypeLiteral<Supplier<DatabaseIdentityStoreDefinition>>(){}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> this.createDatabaseIdentityStoreDefinitionSupplier(beanManager));
            afterBeanDiscovery.addBean().id(TomEEDatabaseIdentityStore.class.getName()).beanClass(TomEEDatabaseIdentityStore.class).types(new Type[]{Object.class, IdentityStore.class, TomEEDatabaseIdentityStore.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> {
                AnnotatedType annotatedType = beanManager.createAnnotatedType(TomEEDatabaseIdentityStore.class);
                BeanAttributes beanAttributes = beanManager.createBeanAttributes(annotatedType);
                return (TomEEDatabaseIdentityStore)beanManager.createBean(beanAttributes, TomEEDatabaseIdentityStore.class, beanManager.getInjectionTargetFactory(annotatedType)).create(creationalContext);
            });
        }
        if (this.ldapStore.get() != null) {
            afterBeanDiscovery.addBean().id(TomEELDAPIdentityStore.class.getName() + "#" + LdapIdentityStoreDefinition.class.getName()).beanClass(Supplier.class).addType(Object.class).addType((TypeLiteral)new TypeLiteral<Supplier<LdapIdentityStoreDefinition>>(){}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> this.createLdapIdentityStoreDefinitionSupplier(beanManager));
            afterBeanDiscovery.addBean().id(TomEELDAPIdentityStore.class.getName()).beanClass(TomEELDAPIdentityStore.class).types(new Type[]{Object.class, IdentityStore.class, TomEELDAPIdentityStore.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> {
                AnnotatedType annotatedType = beanManager.createAnnotatedType(TomEELDAPIdentityStore.class);
                BeanAttributes beanAttributes = beanManager.createBeanAttributes(annotatedType);
                return (TomEELDAPIdentityStore)beanManager.createBean(beanAttributes, TomEELDAPIdentityStore.class, beanManager.getInjectionTargetFactory(annotatedType)).create(creationalContext);
            });
        }
        if (this.basicMechanism.get() != null) {
            afterBeanDiscovery.addBean().id(BasicAuthenticationMechanism.class.getName() + "#" + BasicAuthenticationMechanismDefinition.class.getName()).beanClass(Supplier.class).addType(Object.class).addType((TypeLiteral)new TypeLiteral<Supplier<BasicAuthenticationMechanismDefinition>>(){}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> this.createBasicAuthenticationMechanismDefinitionSupplier(beanManager));
            afterBeanDiscovery.addBean().id(BasicAuthenticationMechanism.class.getName()).beanClass(BasicAuthenticationMechanism.class).types(new Type[]{Object.class, HttpAuthenticationMechanism.class, BasicAuthenticationMechanism.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> {
                AnnotatedType annotatedType = beanManager.createAnnotatedType(BasicAuthenticationMechanism.class);
                BeanAttributes beanAttributes = beanManager.createBeanAttributes(annotatedType);
                return (BasicAuthenticationMechanism)beanManager.createBean(beanAttributes, BasicAuthenticationMechanism.class, beanManager.getInjectionTargetFactory(annotatedType)).create(creationalContext);
            });
        }
        if (this.formMechanism.get() != null) {
            afterBeanDiscovery.addBean().id(FormAuthenticationMechanism.class.getName() + "#" + LoginToContinue.class.getName()).beanClass(Supplier.class).addType(Object.class).addType((TypeLiteral)new TypeLiteral<Supplier<LoginToContinue>>(){}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> this.createFormLoginToContinueSupplier(beanManager));
            afterBeanDiscovery.addBean().id(FormAuthenticationMechanism.class.getName()).beanClass(FormAuthenticationMechanism.class).types(new Type[]{Object.class, HttpAuthenticationMechanism.class, FormAuthenticationMechanism.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> {
                AnnotatedType annotatedType = beanManager.createAnnotatedType(FormAuthenticationMechanism.class);
                BeanAttributes beanAttributes = beanManager.createBeanAttributes(annotatedType);
                return (FormAuthenticationMechanism)beanManager.createBean(beanAttributes, FormAuthenticationMechanism.class, beanManager.getInjectionTargetFactory(annotatedType)).create(creationalContext);
            });
        }
        if (this.customMechanism.get() != null) {
            afterBeanDiscovery.addBean().id(CustomFormAuthenticationMechanism.class.getName() + "#" + LoginToContinue.class.getName()).beanClass(Supplier.class).addType(Object.class).addType((TypeLiteral)new TypeLiteral<Supplier<LoginToContinue>>(){}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> this.createCustomFormLoginToContinueSupplier(beanManager));
            afterBeanDiscovery.addBean().id(CustomFormAuthenticationMechanism.class.getName()).beanClass(CustomFormAuthenticationMechanism.class).types(new Type[]{Object.class, HttpAuthenticationMechanism.class, CustomFormAuthenticationMechanism.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> {
                AnnotatedType annotatedType = beanManager.createAnnotatedType(CustomFormAuthenticationMechanism.class);
                BeanAttributes beanAttributes = beanManager.createBeanAttributes(annotatedType);
                return (CustomFormAuthenticationMechanism)beanManager.createBean(beanAttributes, CustomFormAuthenticationMechanism.class, beanManager.getInjectionTargetFactory(annotatedType)).create(creationalContext);
            });
        }
        if (this.oidcMechanism.get() != null) {
            afterBeanDiscovery.addBean().id(OpenIdAuthenticationMechanism.class.getName() + "#" + OpenIdAuthenticationMechanismDefinition.class.getName()).beanClass(OpenIdAuthenticationMechanismDefinition.class).types(new Type[]{Object.class, OpenIdAuthenticationMechanismDefinition.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> this.createOpenIdAuthenticationMechanismDefinition(beanManager));
            afterBeanDiscovery.addBean().id(OpenIdStorageHandler.class.getName()).beanClass(OpenIdStorageHandler.class).types(new Type[]{Object.class, OpenIdStorageHandler.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> {
                Bean definitionBean = beanManager.resolve(beanManager.getBeans(OpenIdAuthenticationMechanismDefinition.class, new Annotation[0]));
                OpenIdAuthenticationMechanismDefinition definition = (OpenIdAuthenticationMechanismDefinition)beanManager.getReference(definitionBean, OpenIdAuthenticationMechanismDefinition.class, creationalContext);
                return definition.useSession() ? new SessionBasedOpenIdStorageHandler() : new CookieBasedOpenIdStorageHandler();
            });
            afterBeanDiscovery.addBean(this.createBean(TomEEOpenIdContext.class, beanManager));
            afterBeanDiscovery.addBean(this.createBean(OpenIdIdentityStore.class, beanManager));
            afterBeanDiscovery.addBean(this.createBean(OpenIdAuthenticationMechanism.class, beanManager));
        }
    }

    public boolean hasAuthenticationMechanisms() {
        return this.basicMechanism.get() != null || this.formMechanism.get() != null || this.customMechanism.get() != null || this.oidcMechanism.get() != null || this.applicationAuthenticationMechanisms;
    }

    private Supplier<LoginToContinue> createFormLoginToContinueSupplier(BeanManager beanManager) {
        return () -> {
            LoginToContinue loginToContinue = ((FormAuthenticationMechanismDefinition)this.formMechanism.get().getAnnotation(FormAuthenticationMechanismDefinition.class)).loginToContinue();
            return TomEEELInvocationHandler.of(LoginToContinue.class, loginToContinue, beanManager);
        };
    }

    private Supplier<BasicAuthenticationMechanismDefinition> createBasicAuthenticationMechanismDefinitionSupplier(BeanManager beanManager) {
        return () -> {
            BasicAuthenticationMechanismDefinition annotation = (BasicAuthenticationMechanismDefinition)this.basicMechanism.get().getAnnotation(BasicAuthenticationMechanismDefinition.class);
            return TomEEELInvocationHandler.of(BasicAuthenticationMechanismDefinition.class, annotation, beanManager);
        };
    }

    private Supplier<LoginToContinue> createCustomFormLoginToContinueSupplier(BeanManager beanManager) {
        return () -> {
            LoginToContinue annotation = ((CustomFormAuthenticationMechanismDefinition)this.customMechanism.get().getAnnotation(CustomFormAuthenticationMechanismDefinition.class)).loginToContinue();
            return TomEEELInvocationHandler.of(LoginToContinue.class, annotation, beanManager);
        };
    }

    private Supplier<TomcatUserIdentityStoreDefinition> createTomcatUserIdentityStoreDefinitionSupplier(BeanManager beanManager) {
        return () -> {
            TomcatUserIdentityStoreDefinition annotation = (TomcatUserIdentityStoreDefinition)this.tomcatUserStore.get().getAnnotation(TomcatUserIdentityStoreDefinition.class);
            return TomEEELInvocationHandler.of(TomcatUserIdentityStoreDefinition.class, annotation, beanManager);
        };
    }

    private Supplier<DatabaseIdentityStoreDefinition> createDatabaseIdentityStoreDefinitionSupplier(BeanManager beanManager) {
        return () -> {
            DatabaseIdentityStoreDefinition annotation = (DatabaseIdentityStoreDefinition)this.databaseStore.get().getAnnotation(DatabaseIdentityStoreDefinition.class);
            return TomEEELInvocationHandler.of(DatabaseIdentityStoreDefinition.class, annotation, beanManager);
        };
    }

    private Supplier<LdapIdentityStoreDefinition> createLdapIdentityStoreDefinitionSupplier(BeanManager beanManager) {
        return () -> {
            LdapIdentityStoreDefinition annotation = (LdapIdentityStoreDefinition)this.ldapStore.get().getAnnotation(LdapIdentityStoreDefinition.class);
            return TomEEELInvocationHandler.of(LdapIdentityStoreDefinition.class, annotation, beanManager);
        };
    }

    private OpenIdAuthenticationMechanismDefinition createOpenIdAuthenticationMechanismDefinition(BeanManager bm) {
        OpenIdAuthenticationMechanismDefinition annotation = (OpenIdAuthenticationMechanismDefinition)this.oidcMechanism.get().getAnnotation(OpenIdAuthenticationMechanismDefinition.class);
        return new OpenIdAuthenticationMechanismDefinitionDelegate.AutoResolvingProviderMetadata(TomEEELInvocationHandler.of(OpenIdAuthenticationMechanismDefinition.class, annotation, bm));
    }

    private <T> Bean<T> createBean(Class<T> beanType, BeanManager bm) {
        AnnotatedType annotatedType = bm.createAnnotatedType(beanType);
        return bm.createBean(bm.createBeanAttributes(annotatedType), beanType, bm.getInjectionTargetFactory(annotatedType));
    }
}

