/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util.proxy;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.IntFunction;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.DetachedStateManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.util.ChangeTracker;
import org.apache.openjpa.util.CollectionChangeTracker;
import org.apache.openjpa.util.DelayedCollectionChangeTrackerImpl;
import org.apache.openjpa.util.Proxies;
import org.apache.openjpa.util.Proxy;
import org.apache.openjpa.util.proxy.DelayedProxy;
import org.apache.openjpa.util.proxy.ProxyCollection;
import org.apache.openjpa.util.proxy.ProxyCollections;

public class DelayedTreeSetProxy
extends TreeSet
implements ProxyCollection,
DelayedProxy {
    private transient OpenJPAStateManager sm;
    private transient int field;
    private transient CollectionChangeTracker changeTracker;
    private transient Class elementType;
    private transient OpenJPAStateManager _ownerSm;
    private transient boolean _directAccess = false;
    private transient BrokerFactory _brokerFactory = null;
    private transient Broker _broker = null;
    private transient OpenJPAStateManager _delayedSm;
    private transient int _delayedField;
    private transient boolean _detached = false;

    public DelayedTreeSetProxy() {
    }

    public DelayedTreeSetProxy(Comparator paramComparator) {
        super(paramComparator);
    }

    public DelayedTreeSetProxy(Collection paramCollection) {
        super(paramCollection);
    }

    public DelayedTreeSetProxy(SortedSet paramSortedSet) {
        super(paramSortedSet);
    }

    @Override
    public void setOwner(OpenJPAStateManager paramOpenJPAStateManager, int paramInt) {
        if (this.sm != null && this.detaching(paramOpenJPAStateManager, paramInt)) {
            this._detached = true;
            this._delayedSm = this.sm;
            this._delayedField = this.field;
        } else {
            this._detached = false;
        }
        this.sm = paramOpenJPAStateManager;
        if (this.sm != null && this.sm.getPersistenceCapable() != null) {
            this._ownerSm = (OpenJPAStateManager)this.sm.getPersistenceCapable().pcGetStateManager();
        }
        this.field = paramInt;
        if (this.sm != null && this.sm.getContext() != null) {
            this._brokerFactory = this.sm.getContext().getBroker().getBrokerFactory();
        }
    }

    private boolean detaching(OpenJPAStateManager paramOpenJPAStateManager, int paramInt) {
        return paramOpenJPAStateManager == null && paramInt == -1 || paramOpenJPAStateManager != null && paramOpenJPAStateManager instanceof DetachedStateManager;
    }

    @Override
    public OpenJPAStateManager getOwner() {
        return this.sm;
    }

    @Override
    public int getOwnerField() {
        return this.field;
    }

    @Override
    public ChangeTracker getChangeTracker() {
        return this.changeTracker;
    }

    protected void setChangeTracker(CollectionChangeTracker ct) {
        this.changeTracker = ct;
    }

    @Override
    public Object copy(Object paramObject) {
        return new TreeSet((SortedSet)paramObject);
    }

    @Override
    public Class getElementType() {
        return this.elementType;
    }

    protected void setElementType(Class<?> elemType) {
        this.elementType = elemType;
    }

    @Override
    public ProxyCollection newInstance(Class paramClass, Comparator paramComparator, boolean paramBoolean1, boolean paramBoolean2) {
        DelayedTreeSetProxy localproxy = new DelayedTreeSetProxy(paramComparator);
        localproxy.elementType = paramClass;
        if (paramBoolean1) {
            localproxy.changeTracker = new DelayedCollectionChangeTrackerImpl(localproxy, false, false, paramBoolean2);
        }
        return localproxy;
    }

    @Override
    public Object clone() {
        if (this._directAccess) {
            return super.clone();
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        Proxy localProxy = (Proxy)super.clone();
        localProxy.setOwner(null, 0);
        return localProxy;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.isDelayLoad()) {
            this.load();
        }
        return Proxies.writeReplace(this, true);
    }

    @Override
    public int getDelayedField() {
        if (this.field == -1 || this._detached) {
            return this._delayedField;
        }
        return this.field;
    }

    @Override
    public OpenJPAStateManager getDelayedOwner() {
        if (this.sm == null || this._detached) {
            return this._delayedSm;
        }
        return this.sm;
    }

    @Override
    public boolean isDirectAccess() {
        return this._directAccess;
    }

    @Override
    public void setDirectAccess(boolean direct) {
        this._directAccess = direct;
    }

    public BrokerFactory getBrokerFactory() {
        return this._brokerFactory;
    }

    @Override
    public void load() {
        ProxyCollections.loadCollection(this);
    }

    @Override
    public Broker getBroker() {
        if ((this._broker == null || this._broker.isClosed()) && this._brokerFactory != null) {
            this._broker = this._brokerFactory.newBroker();
        }
        return this._broker;
    }

    @Override
    public void closeBroker() {
        if (this._broker != null && !this._broker.isClosed()) {
            this._broker.setAutoDetach(2);
            this._broker.close();
            this._broker = null;
        }
    }

    @Override
    public OpenJPAStateManager getOwnerStateManager() {
        return this._ownerSm;
    }

    @Override
    public boolean isDetached() {
        return this._detached;
    }

    public boolean isDelayLoad() {
        return ProxyCollections.isDelayed(this);
    }

    @Override
    public void clear() {
        if (!this._directAccess) {
            if (this.isDelayLoad()) {
                this.load();
            }
            ProxyCollections.beforeClear(this);
        }
        super.clear();
    }

    @Override
    public Iterator iterator() {
        if (this._directAccess) {
            return super.iterator();
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        Iterator localIterator = super.iterator();
        return ProxyCollections.afterIterator(this, localIterator);
    }

    @Override
    public boolean remove(Object paramObject) {
        if (this._directAccess) {
            return super.remove(paramObject);
        }
        ProxyCollections.beforeRemove((ProxyCollection)this, paramObject);
        this.setDirectAccess(true);
        boolean bool = super.remove(paramObject);
        this.setDirectAccess(false);
        return ProxyCollections.afterRemove((ProxyCollection)this, paramObject, bool);
    }

    @Override
    public int size() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.contains(object);
    }

    @Override
    public Object[] toArray() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.toArray();
    }

    @Override
    public Object[] toArray(Object[] array) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.toArray(array);
    }

    public Object[] toArray(IntFunction generator) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.toArray(generator);
    }

    @Override
    public Comparator comparator() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.comparator();
    }

    @Override
    public Object first() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.first();
    }

    @Override
    public Object last() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.last();
    }

    @Override
    public boolean add(Object paramObject) {
        if (this._directAccess) {
            return super.add(paramObject);
        }
        ProxyCollections.beforeAdd(this, paramObject);
        boolean bool = super.add(paramObject);
        return ProxyCollections.afterAdd(this, paramObject, bool);
    }

    @Override
    public boolean containsAll(Collection c) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.containsAll(c);
    }

    @Override
    public boolean addAll(Collection paramCollection) {
        if (this._directAccess) {
            return super.addAll(paramCollection);
        }
        return ProxyCollections.addAll(this, paramCollection);
    }

    @Override
    public boolean retainAll(Collection paramCollection) {
        if (this._directAccess) {
            return super.retainAll(paramCollection);
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        return ProxyCollections.retainAll(this, paramCollection);
    }

    @Override
    public boolean removeAll(Collection paramCollection) {
        if (this._directAccess) {
            return super.removeAll(paramCollection);
        }
        return ProxyCollections.removeAll(this, paramCollection);
    }

    @Override
    public Object lower(Object e) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.lower(e);
    }

    @Override
    public Object floor(Object e) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.floor(e);
    }

    @Override
    public Object ceiling(Object e) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.ceiling(e);
    }

    @Override
    public Object higher(Object e) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.higher(e);
    }

    @Override
    public Object pollFirst() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.pollFirst();
    }

    @Override
    public Object pollLast() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.pollLast();
    }

    @Override
    public NavigableSet descendingSet() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.descendingSet();
    }

    @Override
    public Iterator descendingIterator() {
        if (this._directAccess) {
            return super.descendingIterator();
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        Iterator localIterator = super.descendingIterator();
        return ProxyCollections.afterIterator(this, localIterator);
    }

    @Override
    public NavigableSet subSet(Object fromElement, boolean fromInclusive, Object toElement, boolean toInclusive) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.subSet(fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public NavigableSet headSet(Object toElement, boolean inclusive) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.headSet(toElement, inclusive);
    }

    @Override
    public NavigableSet tailSet(Object fromElement, boolean inclusive) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.tailSet(fromElement, inclusive);
    }

    @Override
    public SortedSet subSet(Object fromElement, Object toElement) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.subSet(fromElement, toElement);
    }

    @Override
    public SortedSet headSet(Object toElement) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.headSet(toElement);
    }

    @Override
    public SortedSet tailSet(Object fromElement) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.tailSet(fromElement);
    }

    @Override
    public boolean equals(Object paramObject) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.equals(paramObject);
    }

    @Override
    public int hashCode() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.hashCode();
    }
}

