/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.metadata;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.apache.bval.jsr.metadata.AnnotationBehavior;
import org.apache.bval.jsr.metadata.AnnotationBehaviorMergeStrategy;
import org.apache.bval.jsr.metadata.ValidatorMapping;
import org.apache.bval.jsr.metadata.ValidatorMappingProvider;
import org.apache.bval.util.Validate;

public class DualValidationMappingProvider
extends ValidatorMappingProvider {
    private final ValidatorMappingProvider primaryDelegate;
    private final ValidatorMappingProvider secondaryDelegate;

    public DualValidationMappingProvider(ValidatorMappingProvider primary, ValidatorMappingProvider secondary) {
        this.primaryDelegate = Validate.notNull(primary, "primary delegate", new Object[0]);
        this.secondaryDelegate = Validate.notNull(secondary, "secondary delegate", new Object[0]);
    }

    @Override
    protected <A extends Annotation> ValidatorMapping<A> doGetValidatorMapping(Class<A> constraintType) {
        ValidatorMapping<A> secondaryMapping = this.secondaryDelegate.doGetValidatorMapping(constraintType);
        ValidatorMapping<A> primaryMapping = this.primaryDelegate.doGetValidatorMapping(constraintType);
        if (secondaryMapping == null) {
            return primaryMapping;
        }
        AnnotationBehavior annotationBehavior = secondaryMapping.getAnnotationBehavior();
        if (primaryMapping == null || annotationBehavior == AnnotationBehavior.EXCLUDE) {
            return secondaryMapping;
        }
        return ValidatorMapping.merge(Arrays.asList(primaryMapping, secondaryMapping), AnnotationBehaviorMergeStrategy.consensus());
    }
}

