/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.jsl;

import java.util.ArrayList;

public class GlobPatternMatcherImpl {
    public boolean matchWithoutBackslashEscape(String toMatch, String pattern) {
        if (pattern == null || pattern.length() == 0 || toMatch == null || toMatch.length() == 0) {
            throw new IllegalArgumentException("Pattern = " + pattern + "and string to match = " + toMatch + ", but both pattern and to-match String are required to be non-null Strings with length >=1 ");
        }
        String newPattern = pattern;
        while (newPattern.contains("**")) {
            newPattern = newPattern.replace("**", "*");
        }
        return this.recursiveMatch(toMatch, newPattern);
    }

    private boolean recursiveMatch(String toMatch, String subpattern) {
        int firstAsterisk = subpattern.indexOf("*");
        int secondAsterisk = subpattern.indexOf("*", firstAsterisk + 1);
        int lastAsterisk = subpattern.lastIndexOf("*");
        if (firstAsterisk == -1) {
            return this.matchNoAsterisk(toMatch, subpattern);
        }
        if (firstAsterisk > 0) {
            String beginPattern = subpattern.substring(0, firstAsterisk);
            if (toMatch.length() < beginPattern.length()) {
                return false;
            }
            String beginToMatch = toMatch.substring(0, firstAsterisk);
            if (!this.matchNoAsterisk(beginToMatch, beginPattern)) {
                return false;
            }
        }
        String remainingToMatch = toMatch.substring(firstAsterisk);
        if (lastAsterisk < subpattern.length() - 1) {
            String endPattern = subpattern.substring(lastAsterisk + 1);
            if (remainingToMatch.length() < endPattern.length()) {
                return false;
            }
            String endToMatch = remainingToMatch.substring(remainingToMatch.length() - endPattern.length(), remainingToMatch.length());
            if (!this.matchNoAsterisk(endToMatch, endPattern)) {
                return false;
            }
            remainingToMatch = remainingToMatch.substring(0, remainingToMatch.length() - endPattern.length());
        }
        if (firstAsterisk == lastAsterisk) {
            return true;
        }
        if (secondAsterisk == lastAsterisk) {
            String middlePattern = subpattern.substring(firstAsterisk + 1, lastAsterisk);
            if (remainingToMatch.length() < middlePattern.length()) {
                return false;
            }
            for (int i = 0; i <= remainingToMatch.length() - middlePattern.length(); ++i) {
                String matchCandidate = remainingToMatch.substring(i, i + middlePattern.length());
                if (!this.matchNoAsterisk(matchCandidate, middlePattern)) continue;
                return true;
            }
            return false;
        }
        String patternBetweenAsterisk1and2 = subpattern.substring(firstAsterisk + 1, secondAsterisk);
        ArrayList<String> subMatchCandidates = new ArrayList<String>();
        for (int i = 0; i <= remainingToMatch.length() - patternBetweenAsterisk1and2.length(); ++i) {
            String matchCandidate = remainingToMatch.substring(i, i + patternBetweenAsterisk1and2.length());
            if (!this.matchNoAsterisk(matchCandidate, patternBetweenAsterisk1and2)) continue;
            String subMatchCandidate = remainingToMatch.substring(i + patternBetweenAsterisk1and2.length());
            subMatchCandidates.add(subMatchCandidate);
        }
        if (subMatchCandidates.size() == 0) {
            return false;
        }
        String nestedPattern = subpattern.substring(secondAsterisk, lastAsterisk + 1);
        for (String candidate : subMatchCandidates) {
            if (!this.recursiveMatch(candidate, nestedPattern)) continue;
            return true;
        }
        return false;
    }

    private boolean matchNoAsterisk(String toMatch, String subpattern) {
        int subpatternLen;
        int toMatchLen = toMatch.length();
        if (toMatchLen != (subpatternLen = subpattern.length())) {
            return false;
        }
        for (int i = 0; i < toMatchLen; ++i) {
            if (subpattern.substring(i, i + 1).equals("*")) {
                throw new IllegalStateException("Shouldn't have encountered a '*' in matchNoAsterisk, toMatch = " + toMatch + ", subPattern = " + subpattern);
            }
            if (subpattern.substring(i, i + 1).equals("?") || subpattern.charAt(i) == toMatch.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

