/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.monitoring;

import org.apache.geronimo.connector.outbound.GenericConnectionManager;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.NoPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PartitionedPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.SinglePool;
import org.apache.openejb.monitoring.Managed;

public class ConnectionFactoryMonitor {
    private final String name;
    private final GenericConnectionManager connectionManager;
    private final String txSupport;

    public ConnectionFactoryMonitor(String name, GenericConnectionManager connectionManager, String txSupport) {
        this.name = name;
        this.connectionManager = connectionManager;
        this.txSupport = txSupport;
    }

    private PoolingSupport getPooling() {
        return this.connectionManager.getPooling();
    }

    @Managed
    public int getMaxSize() {
        PoolingSupport pooling = this.getPooling();
        if (PartitionedPool.class.isInstance(pooling)) {
            return ((PartitionedPool)PartitionedPool.class.cast(pooling)).getMaxSize();
        }
        if (SinglePool.class.isInstance(pooling)) {
            return ((SinglePool)SinglePool.class.cast(pooling)).getMaxSize();
        }
        if (NoPool.class.isInstance(pooling)) {
            return 0;
        }
        return 0;
    }

    @Managed
    public int getMinSize() {
        PoolingSupport pooling = this.getPooling();
        if (PartitionedPool.class.isInstance(pooling)) {
            return 0;
        }
        if (SinglePool.class.isInstance(pooling)) {
            return ((SinglePool)SinglePool.class.cast(pooling)).getMinSize();
        }
        if (NoPool.class.isInstance(pooling)) {
            return 0;
        }
        return 0;
    }

    @Managed
    public int getBlockingTimeoutMilliseconds() {
        return this.connectionManager.getBlockingTimeoutMilliseconds();
    }

    @Managed
    public int getIdleTimeoutMinutes() {
        return this.connectionManager.getIdleTimeoutMinutes();
    }

    @Managed
    public boolean isMatchAll() {
        PoolingSupport pooling = this.getPooling();
        if (PartitionedPool.class.isInstance(pooling)) {
            return ((PartitionedPool)PartitionedPool.class.cast(pooling)).isMatchAll();
        }
        if (SinglePool.class.isInstance(pooling)) {
            return ((SinglePool)SinglePool.class.cast(pooling)).isMatchAll();
        }
        return false;
    }

    @Managed
    public String getPartitionStrategy() {
        PoolingSupport pooling = this.getPooling();
        if (PartitionedPool.class.isInstance(pooling)) {
            if (((PartitionedPool)PartitionedPool.class.cast(pooling)).isPartitionByConnectionRequestInfo()) {
                return PartitionStrategy.BY_CONNECTOR_PROPERTIES.toString();
            }
            if (((PartitionedPool)PartitionedPool.class.cast(pooling)).isPartitionBySubject()) {
                return PartitionStrategy.BY_SUBJECT.toString();
            }
            return PartitionStrategy.UNKNOWN.toString();
        }
        if (SinglePool.class.isInstance(pooling)) {
            return PartitionStrategy.NONE.toString();
        }
        if (NoPool.class.isInstance(pooling)) {
            return PartitionStrategy.NONE.toString();
        }
        return PartitionStrategy.NONE.toString();
    }

    @Managed
    public String getTxSupport() {
        return this.txSupport;
    }

    @Managed
    public int getPartitionCount() {
        return this.connectionManager.getPartitionCount();
    }

    @Managed
    public int getPartitionMaxSize() {
        return this.connectionManager.getPartitionMaxSize();
    }

    @Managed
    public int getPartitionMinSize() {
        return this.connectionManager.getPartitionMinSize();
    }

    @Managed
    public int getIdleConnectionCount() {
        return this.connectionManager.getIdleConnectionCount();
    }

    @Managed
    public int getConnectionCount() {
        return this.connectionManager.getConnectionCount();
    }

    @Managed
    public String getName() {
        return this.name;
    }

    public static enum PartitionStrategy {
        NONE("none"),
        BY_SUBJECT("by-subject"),
        BY_CONNECTOR_PROPERTIES("by-connector-properties"),
        UNKNOWN("unknown");

        private final String name;

        private PartitionStrategy(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

