/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util.asm;

import java.util.ArrayList;
import java.util.List;
import org.apache.xbean.asm9.ClassWriter;
import org.apache.xbean.asm9.MethodVisitor;

public class ClassWriterTracker {
    private final ClassWriter cw;
    private final ClassLoader cl;
    private String name;
    private List<String> createdMethods = new ArrayList<String>();

    public ClassWriterTracker(ClassWriter cw) {
        this(cw, null);
    }

    public ClassWriterTracker(ClassWriter cw, ClassLoader cl) {
        this.cw = cw;
        this.cl = cl;
    }

    public ClassWriter getCw() {
        return this.cw;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptionTypes) {
        MethodVisitor mv = this.cw.visitMethod(access, name, descriptor, signature, exceptionTypes);
        this.createdMethods.add(name + descriptor);
        return mv;
    }

    public boolean hasMethod(String name, String descriptor) {
        return this.createdMethods.contains(name + descriptor);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

