/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;

public abstract class AbstractConditionalFilter
implements Filter {
    @Nonnull
    private Predicate<ServletRequest> activationCondition = PredicateSupport.alwaysTrue();

    @Nonnull
    public Predicate<ServletRequest> getActivationCondition() {
        return this.activationCondition;
    }

    public void setActivationCondition(@Nonnull Predicate<ServletRequest> condition) {
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Run condition cannot be null");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        assert (request != null);
        assert (response != null);
        assert (chain != null);
        if (this.activationCondition.test(request)) {
            this.runFilter(request, response, chain);
            return;
        }
        chain.doFilter(request, response);
    }

    protected abstract void runFilter(@Nonnull ServletRequest var1, @Nonnull ServletResponse var2, @Nonnull FilterChain var3) throws IOException, ServletException;
}

