/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public class EjbObjectInputStream
extends ObjectInputStream {
    private static final AtomicReference<BlacklistClassResolver> RESOLVER_ATOMIC_REFERENCE = new AtomicReference<BlacklistClassResolver>(new BlacklistClassResolver());

    public static void reloadResolverConfig() {
        RESOLVER_ATOMIC_REFERENCE.set(new BlacklistClassResolver());
    }

    public EjbObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        String n = RESOLVER_ATOMIC_REFERENCE.get().check(classDesc.getName());
        ClassLoader classloader = this.getClassloader();
        try {
            return Class.forName(n, false, classloader);
        }
        catch (ClassNotFoundException e) {
            if (n.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (n.equals("byte")) {
                return Byte.TYPE;
            }
            if (n.equals("char")) {
                return Character.TYPE;
            }
            if (n.equals("short")) {
                return Short.TYPE;
            }
            if (n.equals("int")) {
                return Integer.TYPE;
            }
            if (n.equals("long")) {
                return Long.TYPE;
            }
            if (n.equals("float")) {
                return Float.TYPE;
            }
            if (n.equals("double")) {
                return Double.TYPE;
            }
            return Class.forName(n, false, null);
        }
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] cinterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            cinterfaces[i] = this.getClassloader().loadClass(interfaces[i]);
        }
        try {
            return Proxy.getProxyClass(this.getClassloader(), cinterfaces);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    ClassLoader getClassloader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static class BlacklistClassResolver {
        private final String[] blacklist;
        private final String[] whitelist;
        public static final Pattern PRIMITIVE_ARRAY = Pattern.compile("^\\[+[BCDFIJSVZ]$");

        protected BlacklistClassResolver() {
            this(BlacklistClassResolver.toArray(System.getProperty("tomee.serialization.class.blacklist", "org.codehaus.groovy.runtime.,org.apache.commons.collections.functors.,org.apache.xalan,java.lang.Process")), BlacklistClassResolver.toArray(System.getProperty("tomee.serialization.class.whitelist")));
        }

        protected BlacklistClassResolver(String[] blacklist, String[] whitelist) {
            this.whitelist = whitelist;
            this.blacklist = blacklist;
        }

        protected boolean isBlacklisted(String name) {
            if (PRIMITIVE_ARRAY.matcher(name).matches()) {
                return false;
            }
            if (name != null && name.startsWith("[L") && name.endsWith(";")) {
                return this.isBlacklisted(name.substring(2, name.length() - 1));
            }
            return this.whitelist != null && !BlacklistClassResolver.contains(this.whitelist, name) || BlacklistClassResolver.contains(this.blacklist, name);
        }

        public final String check(String name) {
            if (this.isBlacklisted(name)) {
                throw new SecurityException(name + " is not whitelisted as deserialisable, prevented before loading it, customize tomee.serialization.class.blacklist and tomee.serialization.class.whitelist to add it to not fail there. -Dtomee.serialization.class.blacklist=- -Dtomee.serialization.class.whitelist=" + name + " for instance (or in conf/system.properties).");
            }
            return name;
        }

        private static String[] toArray(String property) {
            return property == null ? null : property.split(" *, *");
        }

        private static boolean contains(String[] list, String name) {
            if (list != null) {
                for (String white : list) {
                    if (!"*".equals(white) && !name.startsWith(white)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

