/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.jee.ApplicationClient;
import org.apache.openejb.jee.JndiConsumer;

public abstract class BaseConvertDefinitions
implements DynamicDeployer {
    protected String cleanUpName(String factory) {
        String name = factory;
        name = name.replaceFirst("java:comp/env/", "");
        name = name.replaceFirst("java:/", "");
        name = name.replaceFirst("java:", "");
        return name;
    }

    protected List<JndiConsumer> collectConsumers(AppModule appModule) {
        ApplicationClient consumer;
        ArrayList<JndiConsumer> jndiConsumers = new ArrayList<JndiConsumer>();
        for (ClientModule module : appModule.getClientModules()) {
            consumer = module.getApplicationClient();
            if (consumer == null) continue;
            jndiConsumers.add((JndiConsumer)consumer);
        }
        for (WebModule webModule : appModule.getWebModules()) {
            consumer = webModule.getWebApp();
            if (consumer == null) continue;
            jndiConsumers.add((JndiConsumer)consumer);
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            Collections.addAll(jndiConsumers, ejbModule.getEjbJar().getEnterpriseBeans());
        }
        if (appModule.getApplication() != null) {
            jndiConsumers.add((JndiConsumer)appModule.getApplication());
        }
        return jndiConsumers;
    }
}

