/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina.cluster;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.catalina.ha.ClusterListener;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.core.LocalInitialContextFactory;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.DaemonThreadFactory;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.catalina.cluster.DeployMessage;
import org.apache.tomee.catalina.cluster.UndeployMessage;

public class TomEEClusterListener
extends ClusterListener {
    public void messageReceived(ClusterMessage clusterMessage) {
        Class<?> type = clusterMessage.getClass();
        if (DeployMessage.class.equals(type)) {
            DeployMessage msg = (DeployMessage)clusterMessage;
            String file = msg.getFile();
            boolean alreadyDeployed = TomEEClusterListener.isDeployed(file);
            File ioFile = new File(file);
            if (!alreadyDeployed) {
                if (msg.getArchive() != null) {
                    File deployed = this.deployedDir();
                    try {
                        if (!deployed.exists()) {
                            Files.mkdirs((File)deployed);
                        }
                        File dump = new File(deployed, ioFile.getName());
                        IO.copy((byte[])msg.getArchive(), (File)dump);
                        file = dump.getAbsolutePath();
                        ioFile = new File(file);
                        Static.LOGGER.info("dumped archive: " + msg.getFile() + " to " + file);
                    }
                    catch (Exception e) {
                        Static.LOGGER.error("can't dump archive: " + file, (Throwable)e);
                    }
                }
                if (ioFile.exists()) {
                    Static.SERVICE.submit(new DeployTask(file));
                } else {
                    Static.LOGGER.warning("can't find '" + file);
                }
            } else {
                Static.LOGGER.info("application already deployed: " + file);
            }
        } else if (UndeployMessage.class.equals(type)) {
            String file = ((UndeployMessage)clusterMessage).getFile();
            if (TomEEClusterListener.isDeployed(file)) {
                Static.SERVICE.submit(new UndeployTask(file));
            } else {
                File alternativeFile = new File(this.deployedDir(), new File(file).getName());
                if (TomEEClusterListener.isDeployed(alternativeFile.getAbsolutePath())) {
                    Static.SERVICE.submit(new UndeployTask(alternativeFile.getAbsolutePath()));
                }
                Static.LOGGER.info("app '" + file + "' was not deployed");
            }
        } else {
            Static.LOGGER.warning("message type not supported: " + type);
        }
    }

    private File deployedDir() {
        return new File(SystemInstance.get().getHome().getDirectory(), "deployed");
    }

    private static boolean isDeployed(String file) {
        return ((Assembler)SystemInstance.get().getComponent(Assembler.class)).isDeployed(file);
    }

    private static Deployer deployer() throws NamingException {
        return (Deployer)new InitialContext(Static.IC_PROPS).lookup("openejb/DeployerBusinessRemote");
    }

    public boolean accept(ClusterMessage clusterMessage) {
        return clusterMessage != null && (DeployMessage.class.equals(clusterMessage.getClass()) || UndeployMessage.class.equals(clusterMessage.getClass()));
    }

    public static void stop() {
        Static.SERVICE.shutdown();
        try {
            Static.SERVICE.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Static.SERVICE.shutdownNow();
        }
    }

    private static final class Static {
        private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB, TomEEClusterListener.class);
        private static final Properties IC_PROPS = new Properties();
        private static final ExecutorService SERVICE = Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory(new Object[]{"TomEE-Cluster-Listener-thread-"}));

        private Static() {
        }

        static {
            IC_PROPS.setProperty("java.naming.factory.initial", LocalInitialContextFactory.class.getName());
        }
    }

    private static class DeployTask
    implements Runnable {
        private final String app;
        private static final Properties REMOTE_DEPLOY_PROPERTIES = new Properties();

        public DeployTask(String ioFile) {
            this.app = ioFile;
        }

        @Override
        public void run() {
            if (!TomEEClusterListener.isDeployed(this.app)) {
                try {
                    TomEEClusterListener.deployer().deploy(this.app, REMOTE_DEPLOY_PROPERTIES);
                }
                catch (OpenEJBException e) {
                    Static.LOGGER.warning("can't deploy: " + this.app, (Throwable)e);
                }
                catch (NamingException e) {
                    Static.LOGGER.warning("can't find deployer", (Throwable)e);
                }
            }
        }

        static {
            REMOTE_DEPLOY_PROPERTIES.setProperty("openejb.app.autodeploy", "true");
        }
    }

    private static class UndeployTask
    implements Runnable {
        private final String app;

        public UndeployTask(String ioFile) {
            this.app = ioFile;
        }

        @Override
        public void run() {
            if (TomEEClusterListener.isDeployed(this.app)) {
                try {
                    TomEEClusterListener.deployer().undeploy(this.app);
                }
                catch (UndeployException e) {
                    Static.LOGGER.error("can't undeploy app", (Throwable)e);
                }
                catch (NoSuchApplicationException e) {
                    Static.LOGGER.warning("no app toi deploy", (Throwable)e);
                }
                catch (NamingException e) {
                    Static.LOGGER.warning("can't find deployer", (Throwable)e);
                }
            }
        }
    }
}

