/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.cdi;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.microprofile.jwt.JsonWebToken;

@ApplicationScoped
public class MPJWTProducer {
    @Inject
    private HttpServletRequest httpServletRequest;

    @Produces
    @RequestScoped
    public JsonWebToken currentPrincipal() {
        Objects.requireNonNull(this.httpServletRequest, "HTTP Servlet Request is required to produce a JSonWebToken principal.");
        Object tokenAttribute = this.httpServletRequest.getAttribute(JsonWebToken.class.getName());
        if (Function.class.isInstance(tokenAttribute)) {
            return (JsonWebToken)((Function)Function.class.cast(tokenAttribute)).apply(this.httpServletRequest);
        }
        return null;
    }
}

