/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.locator;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.services.locator.SingletonLocator;

public class ClassLoaderLocator
extends SingletonLocator {
    private static final Map<ClassLoader, ServicesManager> MANAGERS = new ConcurrentHashMap<ClassLoader, ServicesManager>();

    public static void setServiceManager(ClassLoader key, ServicesManager manager) {
        MANAGERS.put(key, manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeServiceManager(ClassLoader key, Properties props) {
        ServicesManager mgr = new ServicesManager();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(key);
        try {
            mgr.init(props);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        ClassLoaderLocator.setServiceManager(key, mgr);
    }

    public static ServicesManager resetServiceManager(ClassLoader key) {
        return MANAGERS.remove(key);
    }

    @Override
    public ServicesManager find() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl == null) {
            return super.find();
        }
        do {
            ServicesManager mgr;
            if ((mgr = MANAGERS.get(tccl)) == null) continue;
            return mgr;
        } while ((tccl = tccl.getParent()) != null);
        return super.find();
    }
}

