/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client;

import java.security.AccessController;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cxf.jaxrs.ext.MessageContext;

public final class Utils {
    private Utils() {
    }

    public static ExecutorService getExecutorService(MessageContext mc) {
        ExecutorService es = (ExecutorService)mc.get((Object)"executorService");
        if (es == null) {
            es = Utils.getCommonPool();
        }
        return es;
    }

    public static ExecutorService defaultExecutorService() {
        return new LazyForkJoinExecutor();
    }

    private static ExecutorService getCommonPool() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> ForkJoinPool.commonPool());
        }
        return ForkJoinPool.commonPool();
    }

    private static final class LazyForkJoinExecutor
    implements ExecutorService {
        private LazyForkJoinExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            Utils.getCommonPool().execute(command);
        }

        @Override
        public void shutdown() {
            Utils.getCommonPool().shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return Utils.getCommonPool().shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return Utils.getCommonPool().isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return Utils.getCommonPool().isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return Utils.getCommonPool().awaitTermination(timeout, unit);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return Utils.getCommonPool().submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return Utils.getCommonPool().submit(task, result);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return Utils.getCommonPool().submit(task);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return Utils.getCommonPool().invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return Utils.getCommonPool().invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return Utils.getCommonPool().invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return Utils.getCommonPool().invokeAny(tasks, timeout, unit);
        }
    }
}

