/*
 * Decompiled with CFR 0.152.
 */
package org.metatype.sxc.util;

import java.util.Arrays;
import java.util.LinkedList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class PrettyPrintXMLStreamWriter
implements XMLStreamWriter {
    public static final int DEFAULT_INDENT_SIZE = 4;
    public static final String DEFAULT_NEW_LINE = "\n";
    private final XMLStreamWriter writer;
    private final String indentString;
    private final String newLine;
    private final LinkedList<Element> elements = new LinkedList();
    private int indentLevel;

    public PrettyPrintXMLStreamWriter(XMLStreamWriter writer) {
        this(writer, 4, DEFAULT_NEW_LINE);
    }

    public PrettyPrintXMLStreamWriter(XMLStreamWriter writer, int indentSize) {
        this(writer, indentSize, DEFAULT_NEW_LINE);
    }

    public PrettyPrintXMLStreamWriter(XMLStreamWriter writer, int indentSize, String newLine) {
        this.writer = writer;
        char[] chars = new char[indentSize];
        Arrays.fill(chars, ' ');
        this.indentString = new String(chars);
        this.newLine = newLine;
    }

    public int getIndentSize() {
        return this.indentString.length();
    }

    private String getNewLine() {
        return this.newLine;
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.beforeStartElement(localName, null);
        this.writeStartElement(null, null, localName);
        this.afterStartElement(localName, null);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.beforeStartElement(localName, namespaceURI);
        this.writeStartElement(null, namespaceURI, localName);
        this.afterStartElement(localName, namespaceURI);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.beforeStartElement(localName, namespaceURI);
        this.writer.writeStartElement(prefix, localName, namespaceURI);
        this.afterStartElement(localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.beforeStartElement(localName, null);
        this.writer.writeEmptyElement(localName);
        this.afterEndElement();
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.beforeStartElement(localName, null);
        this.writeEmptyElement(null, namespaceURI, localName);
        this.afterEndElement();
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.beforeStartElement(localName, null);
        this.writer.writeEmptyElement(prefix, localName, namespaceURI);
        this.afterEndElement();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.beforeEndElement();
        this.writer.writeEndElement();
        this.afterEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.beforeEndDocument();
        this.writer.writeEndDocument();
        this.afterEndDocument();
    }

    @Override
    public void close() throws XMLStreamException {
        this.writer.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writeAttribute(null, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writeAttribute(null, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.writer.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.writer.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.writer.writeComment(data);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.beforeProcessingInstruction();
        this.writer.writeProcessingInstruction(target);
        this.afterProcessingInstruction();
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.beforeProcessingInstruction();
        this.writer.writeProcessingInstruction(target, data);
        this.afterProcessingInstruction();
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.writer.writeCData(data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.beforeProcessingInstruction();
        this.writer.writeDTD(dtd);
        this.afterProcessingInstruction();
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.writer.writeEntityRef(name);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.beforeStartDocument();
        this.writer.writeStartDocument();
        this.afterStartDocument();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.beforeStartDocument();
        this.writer.writeStartDocument(version);
        this.afterStartDocument();
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.beforeStartDocument();
        this.writer.writeStartDocument(encoding, version);
        this.afterStartDocument();
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.writer.writeCharacters(text.trim());
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.writeCharacters(new String(text, start, len));
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.writer.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.writer.setPrefix(prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.writer.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.writer.setNamespaceContext(namespaceContext);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.writer.getProperty(name);
    }

    protected void beforeStartDocument() throws XMLStreamException {
    }

    protected void afterStartDocument() throws XMLStreamException {
        this.writeNewLine();
    }

    protected void beforeEndDocument() throws XMLStreamException {
    }

    protected void afterEndDocument() throws XMLStreamException {
    }

    private void beforeProcessingInstruction() throws XMLStreamException {
        if (this.elements.isEmpty()) {
            this.writeAndIncreaseIndent();
        } else {
            this.writer.writeCharacters("");
            this.writeNewLine();
            this.writeAndIncreaseIndent();
            Element element = this.elements.peek();
            element.setChildElements(true);
        }
    }

    private void afterProcessingInstruction() throws XMLStreamException {
        if (this.elements.isEmpty()) {
            this.writeNewLine();
        }
    }

    protected void beforeStartElement(String localName, String namespaceURI) throws XMLStreamException {
        if (this.elements.isEmpty()) {
            this.writeAndIncreaseIndent();
        } else {
            this.writer.writeCharacters("");
            this.writeNewLine();
            this.writeAndIncreaseIndent();
            Element element = this.elements.peek();
            element.setChildElements(true);
        }
        this.elements.addFirst(new Element(localName));
    }

    protected void afterStartElement(String localName, String namespaceURI) throws XMLStreamException {
    }

    protected void beforeEndElement() throws XMLStreamException {
        Element element = this.elements.remove();
        this.unindent();
        if (element.hasChildElements()) {
            this.writeNewLine();
            this.writeIndent();
        }
    }

    protected void afterEndElement() throws XMLStreamException {
        if (this.elements.isEmpty()) {
            this.writeNewLine();
        }
    }

    private void writeNewLine() throws XMLStreamException {
        this.writer.writeCharacters(this.getNewLine());
    }

    protected void writeIndent() throws XMLStreamException {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.writer.writeCharacters(this.indentString);
        }
    }

    protected void writeAndIncreaseIndent() throws XMLStreamException {
        this.writeIndent();
        this.indent();
    }

    protected void indent() {
        ++this.indentLevel;
    }

    protected void unindent() {
        --this.indentLevel;
    }

    private static class Element {
        private final String localName;
        private boolean hasChildElements;

        Element(String localName) {
            this.localName = localName;
        }

        public boolean hasChildElements() {
            return this.hasChildElements;
        }

        public void setChildElements(boolean childElements) {
            this.hasChildElements = childElements;
        }

        public String toString() {
            return this.localName;
        }
    }
}

