/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.parser.ast;

import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;

public class RutaExpression
extends Expression {
    private Expression expression;
    private boolean inParantheses;
    private int type;

    public RutaExpression(int sourceStart, int sourceEnd, Expression expression, int type) {
        super(sourceStart, sourceEnd);
        this.expression = expression;
        this.type = type;
        this.inParantheses = false;
        if (expression instanceof RutaExpression) {
            this.inParantheses = ((RutaExpression)expression).isInParantheses();
        }
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Expression)this)) {
            if (this.expression != null) {
                this.expression.traverse(visitor);
            }
            visitor.endvisit((Expression)this);
        }
    }

    public Expression getExpression() {
        return this.expression == null ? this : this.expression;
    }

    public int getKind() {
        return this.type;
    }

    public boolean isInParantheses() {
        return this.inParantheses;
    }

    public void setInParantheses(boolean inParantheses) {
        this.inParantheses = inParantheses;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " : " + super.toString();
    }
}

