/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.util.Iterator;
import org.apache.camel.Exchange;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.util.ObjectHelper;

public final class ObjectConverterOptimised {
    private ObjectConverterOptimised() {
    }

    public static Object convertTo(Class<?> type, Exchange exchange, Object value) throws Exception {
        if (type == String.class) {
            Class<?> fromType = value.getClass();
            if (fromType == Boolean.TYPE || fromType == Boolean.class) {
                return value.toString();
            }
            if (fromType == Integer.TYPE || fromType == Integer.class) {
                return value.toString();
            }
            if (fromType == Long.TYPE || fromType == Long.class) {
                return value.toString();
            }
            if (fromType == char[].class) {
                return ObjectConverter.fromCharArray((char[])value);
            }
            if (fromType == StringBuffer.class || fromType == StringBuilder.class) {
                return value.toString();
            }
            return null;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return ObjectConverter.toBoolean(value);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return ObjectConverter.toInteger(value);
        }
        if (type == Long.TYPE || type == Long.class) {
            return ObjectConverter.toLong(value);
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return ObjectConverter.toByte(value);
        }
        if (type == Double.TYPE || type == Double.class) {
            return ObjectConverter.toDouble(value);
        }
        if (type == Float.TYPE || type == Float.class) {
            return ObjectConverter.toFloat(value);
        }
        if (type == Short.TYPE || type == Short.class) {
            return ObjectConverter.toShort(value);
        }
        if ((type == Character.TYPE || type == Character.class) && value.getClass() == String.class) {
            return ObjectConverter.toCharacter((String)value);
        }
        if ((type == char[].class || type == Character[].class) && value.getClass() == String.class) {
            return ObjectConverter.toCharArray((String)value);
        }
        if (type == Iterator.class) {
            return ObjectHelper.createIterator(value);
        }
        if (type == Iterable.class) {
            return ObjectHelper.createIterable(value);
        }
        if (type == Class.class) {
            return ObjectConverter.toClass(value, exchange);
        }
        return null;
    }
}

