/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ExchangeHelper;

public class StringDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private String charset;

    public StringDataFormat() {
    }

    public StringDataFormat(String charset) {
        this.charset = charset;
    }

    @Override
    public String getDataFormatName() {
        return "string";
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws IOException {
        String text = ExchangeHelper.convertToType(exchange, String.class, graph);
        byte[] bytes = this.charset != null ? text.getBytes(this.charset) : text.getBytes();
        stream.write(bytes);
    }

    @Override
    public Object unmarshal(Exchange exchange, InputStream stream) throws IOException {
        byte[] bytes = ExchangeHelper.convertToType(exchange, byte[].class, stream);
        String answer = this.charset != null ? new String(bytes, this.charset) : new String(bytes);
        return answer;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

